<?php
session_start();
include 'db.php';

header("Content-Type: text/html; charset=UTF-8");
if (function_exists('mysqli_set_charset')) {
    mysqli_set_charset($conn, "utf8mb4");
}

// ✅ ضبط التوقيت على بغداد
date_default_timezone_set('Asia/Baghdad');

/* ✅ لو المدرّس مسجّل دخول نحوله مباشرة */
if (isset($_SESSION['teacher_id']) && $_SESSION['teacher_id'] != '') {
    header("Location: dashboard_teacher.php");
    exit();
}

$error = "";

/**
 * ✅ دالة مساعدة لتسجيل الأخطاء في ملف
 * يتم إنشاء ملف error_login_teachers.log في نفس المجلد
 */
function log_login_error($msg) {
    $file = __DIR__ . '/error_login_teachers.log';
    $line = date('Y-m-d H:i:s') . " - " . $msg . "\n";
    @file_put_contents($file, $line, FILE_APPEND);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $password = isset($_POST['password']) ? trim($_POST['password']) : '';

    if ($password == '') {
        $error = "⚠️ يرجى إدخال كلمة المرور.";
    } else {

        // ✅ أولاً نتأكد من أن الاتصال بقاعدة البيانات سليم
        if (!$conn) {
            $err_no  = mysqli_connect_errno();
            $err_msg = mysqli_connect_error();
            log_login_error("DB CONNECT ERROR {$err_no}: {$err_msg}");

            // لو السيرفر مزدحم
            if ($err_no == 1040 || $err_no == 1203) {
                $error = "⚠️ السيرفر مزدحم حالياً بسبب كثرة الاتصالات، يرجى المحاولة بعد دقيقة.";
            } else {
                $error = "⚠️ خطأ في الاتصال بقاعدة البيانات. يرجى المحاولة لاحقاً.";
            }
        } else {

            $stmt = mysqli_prepare($conn, "SELECT id, name, subject, stages, classes FROM teachers WHERE password = ? LIMIT 1");

            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "s", $password);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_store_result($stmt);

                if (mysqli_stmt_num_rows($stmt) === 1) {
                    mysqli_stmt_bind_result($stmt, $id, $name, $subject, $stages, $classes);
                    mysqli_stmt_fetch($stmt);
                    mysqli_stmt_close($stmt);

                    // ✅ لو المادة فارغة نجيبها من جدول المواد
                    if (trim($subject) == "" || $subject == null) {
                        $sub_q = mysqli_query($conn, "SELECT name FROM subjects WHERE teacher_id='" . (int)$id . "' LIMIT 1");
                        if ($sub_q && mysqli_num_rows($sub_q) > 0) {
                            $row = mysqli_fetch_assoc($sub_q);
                            $subject = $row['name'];
                        } else {
                            $subject = "غير محدد";
                        }
                    }

                    // ✅ تخزين بيانات المدرس في السيشن
                    $_SESSION['teacher_id']      = $id;
                    $_SESSION['teacher_name']    = $name;
                    $_SESSION['teacher_subject'] = $subject;
                    $_SESSION['teacher_stages']  = $stages;
                    $_SESSION['teacher_classes'] = $classes;

                    // ================= تسجيل عملية الدخول في جدول teacher_login_log =================
                    if (isset($_SESSION['teacher_id'])) {
                        $teacher_id      = (int)$_SESSION['teacher_id'];
                        $teacher_name    = isset($_SESSION['teacher_name']) ? $_SESSION['teacher_name'] : '';
                        $teacher_subject = isset($_SESSION['teacher_subject']) ? $_SESSION['teacher_subject'] : '';

                        // جلب IP و User Agent
                        $ip_address = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';
                        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';

                        // تأمين النصوص
                        $teacher_name_db    = mysqli_real_escape_string($conn, $teacher_name);
                        $teacher_subject_db = mysqli_real_escape_string($conn, $teacher_subject);
                        $ip_address_db      = mysqli_real_escape_string($conn, $ip_address);
                        $user_agent_db      = mysqli_real_escape_string($conn, $user_agent);

                        // ✅ وقت الدخول من PHP بعد ضبط التوقيت
                        $login_time = date('Y-m-d H:i:s');

                        $sql_log = "
                            INSERT INTO teacher_login_log
                            (teacher_id, teacher_name, subject, ip_address, user_agent, login_time)
                            VALUES
                            (
                                ".$teacher_id.",
                                '".$teacher_name_db."',
                                '".$teacher_subject_db."',
                                '".$ip_address_db."',
                                '".$user_agent_db."',
                                '".$login_time."'
                            )
                        ";
                        if (!mysqli_query($conn, $sql_log)) {
                            // نسجل الخطأ فقط للمتابعة
                            log_login_error("LOGIN LOG INSERT ERROR: " . mysqli_error($conn));
                        }
                    }
                    // ========================================================================

                    header("Location: dashboard_teacher.php");
                    exit();
                } else {
                    $error = "❌ كلمة المرور غير صحيحة!";
                }
            } else {
                // ✅ فشل في mysqli_prepare → غالباً مشكلة في قاعدة البيانات / ضغط اتصالات
                $err_no  = mysqli_errno($conn);
                $err_msg = mysqli_error($conn);
                log_login_error("PREPARE ERROR {$err_no}: {$err_msg}");

                if ($err_no == 1040 || $err_no == 1203) {
                    // Too many connections / max_user_connections
                    $error = "⚠️ السيرفر مزدحم حالياً بسبب كثرة محاولات الدخول. يرجى المحاولة بعد دقيقة.";
                } else {
                    $error = "⚠️ خطأ في الاتصال بقاعدة البيانات. (رمز الخطأ: {$err_no})";
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>🎓 تسجيل دخول المدرسين | ثانوية الأوائل الأهلية للبنين</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%, #1a1f3b, #0b0d18 80%);
  color:#fff;
  display:flex;
  justify-content:center;
  align-items:center;
  padding:20px;
  position:relative;
}
body::before{
  content:"";
  position:fixed;
  top:-50%;
  left:-50%;
  width:200%;
  height:200%;
  background:
    radial-gradient(circle at 30% 30%, rgba(0,255,255,0.2), transparent 70%),
    radial-gradient(circle at 70% 70%, rgba(255,215,0,0.2), transparent 80%),
    radial-gradient(circle at 50% 100%, rgba(138,43,226,0.15), transparent 60%);
  animation:nebula 25s linear infinite alternate;
  filter:blur(90px);
  z-index:0;
}
@keyframes nebula{0%{transform:rotate(0deg) scale(1)}100%{transform:rotate(360deg) scale(1.2)}}

.container{
  position:relative;
  z-index:1;
  width:100%;
  max-width:420px;
  background:rgba(255,255,255,0.08);
  border-radius:25px;
  backdrop-filter:blur(18px);
  box-shadow:0 0 40px rgba(0,255,255,0.15);
  text-align:center;
  padding:40px 25px 35px;
  border:1px solid rgba(255,255,255,0.15);
  animation:fadeIn 1.2s ease-in-out;
}
@keyframes fadeIn{
  from{opacity:0;transform:translateY(40px)}
  to{opacity:1;transform:translateY(0)}
}

.logo{
  width:110px;
  height:110px;
  margin:0 auto 15px;
  background:radial-gradient(circle, rgba(255,215,0,0.15), transparent 70%);
  border-radius:50%;
  box-shadow:0 0 35px rgba(255,215,0,0.3);
  display:flex;
  justify-content:center;
  align-items:center;
  animation:glow 3s ease-in-out infinite alternate;
}
.logo img{width:75px;height:75px;object-fit:contain}
@keyframes glow{
  0%{box-shadow:0 0 10px rgba(255,215,0,0.4)}
  100%{box-shadow:0 0 25px rgba(0,255,255,0.6)}
}

h1{font-size:21px;margin-bottom:4px}
h2{font-size:14.5px;color:#00e6ff;margin-bottom:20px}

input[type="password"]{
  width:100%;
  padding:13px;
  border-radius:12px;
  border:none;
  outline:none;
  background:rgba(255,255,255,0.95);
  font-size:16px;
  text-align:center;
  color:#111;
  margin-bottom:18px;
  transition:0.3s;
}
input[type="password"]:focus{
  box-shadow:0 0 15px rgba(0,255,255,0.6);
  transform:scale(1.01);
}

button{
  width:100%;
  padding:13px;
  border:none;
  border-radius:12px;
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;
  font-size:17px;
  font-weight:bold;
  cursor:pointer;
  transition:0.3s;
}
button:hover{
  transform:scale(1.02);
  box-shadow:0 0 25px rgba(0,255,255,0.5);
}

.error{
  background-color:rgba(255,0,0,0.25);
  border:1px solid rgba(255,100,100,0.5);
  color:#fff;
  padding:9px 10px;
  border-radius:10px;
  margin-bottom:15px;
  font-size:13.5px;
  backdrop-filter:blur(5px);
  text-align:center;
}

footer{
  margin-top:22px;
  font-size:12.5px;
  color:#ccc;
}
footer span{color:#00e6ff}

@media (max-width:420px){
  .container{
    padding:32px 18px 28px;
    border-radius:20px;
  }
  h1{font-size:19px}
  h2{font-size:13.5px}
}
</style>
</head>
<body>

<div class="container">
  <div class="logo">
    <img src="bookk.png" alt="شعار المدرسة">
  </div>
  <h1>🎓 ثانوية الأوائل الأهلية للبنين</h1>
  <h2>تسجيل دخول المدرسين</h2>

  <?php if ($error != ""): ?>
      <div class="error"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
  <?php endif; ?>

  <form method="post" action="">
      <input type="password" name="password" placeholder="أدخل كلمة المرور" required>
      <button type="submit">تسجيل الدخول</button>
  </form>

  <footer>
      © <span><?php echo date("Y"); ?></span> جميع الحقوق محفوظة - <b>ثانوية الأوائل الأهلية</b>
  </footer>
</div>

</body>
</html>
