<?php
include('config.php');

// حذف مورد
if (isset($_GET['delete_id'])) {
    $del_id = intval($_GET['delete_id']);
    // حذف المورد وكل معاملاته المالية تلقائيًا بسبب on delete cascade في القاعدة
    mysqli_query($conn, "DELETE FROM suppliers WHERE id = $del_id");
    header("Location: suppliers.php?deleted=1");
    exit;
}

// إضافة مورد جديد
if (isset($_POST['add_supplier']) && trim($_POST['name']) != '') {
    $name = mysqli_real_escape_string($conn, trim($_POST['name']));
    mysqli_query($conn, "INSERT INTO suppliers (name) VALUES ('$name')");
    header("Location: suppliers.php?added=1");
    exit;
}

// جلب الموردين
$suppliers = [];
$res = mysqli_query($conn, "SELECT * FROM suppliers ORDER BY name");
while ($row = mysqli_fetch_assoc($res)) $suppliers[] = $row;

// حساب ديون كل مورد
$debts = [];
if ($suppliers) {
    $ids = implode(',', array_column($suppliers, 'id'));
    $q = mysqli_query($conn, "
        SELECT supplier_id, 
               SUM(CASE WHEN trans_type='purchase' THEN amount ELSE 0 END) as total_purchases,
               SUM(CASE WHEN trans_type='payment'  THEN amount ELSE 0 END) as total_payments
        FROM supplier_transactions 
        WHERE supplier_id IN ($ids)
        GROUP BY supplier_id
    ");
    while ($r = mysqli_fetch_assoc($q)) {
        $debts[$r['supplier_id']] = floatval($r['total_purchases']) - floatval($r['total_payments']);
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الموردين والديون</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {background: #f7fafd; font-family: 'Cairo', Arial, sans-serif; margin:0;}
        .container {max-width: 850px; margin: 40px auto 0; background: #fff; border-radius: 25px; box-shadow: 0 8px 40px #e0ebfa80; padding: 34px 18px 23px;}
        h2 {text-align:center;color:#1976d2;font-size:2rem;margin-bottom:22px;}
        .suppliers-table {width:100%;border-collapse:collapse;margin-bottom:16px;}
        .suppliers-table th, .suppliers-table td {
            padding:12px 7px;
            border-bottom:1.3px solid #dbe7f3;
            font-size:1.08rem;
            text-align: center; /* <-- كل الأعمدة بالنص */
        }
        .suppliers-table th {background:#e8f0fe;}
        .suppliers-table td {background:#f9fbfd;}
        .suppliers-table td.negative {color:#c90022;font-weight:bold;}
        .suppliers-table td.positive {color:#1fa57e;font-weight:bold;}
        .btn, .btn-action, .btn-delete {
            padding:7px 17px;
            border-radius:8px;
            font-weight:600;
            font-size:1rem;
            border:0;
            cursor:pointer;
        }
        .btn {background:#1976d2;color:#fff;transition:background 0.13s;}
        .btn:hover {background:#144e8b;}
        .btn-action {background:#f7b901;color:#fff;margin-left:5px;}
        .btn-delete {background:#ff6868;color:#fff;}
        .add-supplier-box {background:#eaf6ff;padding:16px 12px 9px 12px;border-radius:15px;margin-bottom:25px;}
        .add-supplier-box input {width:90%;margin-bottom:9px;padding:7px 11px;border-radius:7px;border:1.1px solid #dbe2e8;font-size:1.08rem;}
        .search-box {margin-bottom:18px;text-align:left;}
        .search-box input {width:40%;padding:7px 13px;border-radius:8px;border:1.2px solid #c8d0e4;font-size:1.07rem;}
        @media (max-width: 700px) {
            .container {max-width:99vw;padding:10px;}
            .suppliers-table th, .suppliers-table td {font-size:0.98rem;}
            .add-supplier-box input, .search-box input {width:99%;}
        }
    </style>
    <script>
    function searchSuppliers() {
        var val = document.getElementById('searchInput').value.trim().toLowerCase();
        document.querySelectorAll('.suppliers-table tbody tr').forEach(function(tr){
            var t = tr.innerText.toLowerCase();
            tr.style.display = t.indexOf(val) !== -1 ? '' : 'none';
        });
    }
    function confirmDelete(name, id) {
        if (confirm('هل أنت متأكد أنك تريد حذف المورد "'+name+'" وكل العمليات المرتبطة به نهائياً؟')) {
            window.location = 'suppliers.php?delete_id='+id;
        }
    }
    </script>
</head>
<body>
<div class="container">
    <h2><i class="fa fa-users"></i> إدارة الموردين والديون</h2>

    <!-- إضافة مورد جديد -->
    <div class="add-supplier-box">
        <form method="post" style="display:flex;gap:15px;flex-wrap:wrap;align-items:center;">
            <input type="text" name="name" placeholder="اسم المورد" required>
            <button class="btn" name="add_supplier"><i class="fa fa-plus"></i> إضافة</button>
        </form>
    </div>

    <!-- بحث الموردين -->
    <div class="search-box">
        <input type="text" id="searchInput" onkeyup="searchSuppliers();" placeholder="ابحث عن مورد...">
    </div>

    <!-- جدول الموردين -->
    <table class="suppliers-table">
        <thead>
            <tr>
                <th>الاسم</th>
                <th>الدين الحالي</th>
                <th>عمليات</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($suppliers as $s): 
            $debt = isset($debts[$s['id']]) ? $debts[$s['id']] : 0;
        ?>
            <tr>
                <td><?= htmlspecialchars($s['name']); ?></td>
                <td class="<?= $debt > 0 ? 'negative' : 'positive'; ?>">
                    <?= number_format($debt, 2); ?> د.ع
                </td>
                <td>
                    <a href="supplier_details.php?id=<?= $s['id']; ?>" class="btn-action"><i class="fa fa-eye"></i> عرض</a>
                    <button type="button" class="btn-delete" onclick="confirmDelete('<?= htmlspecialchars($s['name']); ?>', <?= $s['id']; ?>)"><i class="fa fa-trash"></i> حذف</button>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
