<?php
include('config.php');

$supplier_id = isset($_POST['supplier_id']) ? intval($_POST['supplier_id']) : 0;
$new_supplier = isset($_POST['new_supplier']) ? trim($_POST['new_supplier']) : '';
$notes = isset($_POST['notes']) ? mysqli_real_escape_string($conn, $_POST['notes']) : '';
$paid = isset($_POST['paid']) ? floatval($_POST['paid']) : 0;
$total = 0;

// إضافة مورد جديد إذا لزم الأمر
if ($supplier_id == 0 && $new_supplier != "") {
    mysqli_query($conn, "INSERT INTO suppliers (name) VALUES ('" . mysqli_real_escape_string($conn, $new_supplier) . "')");
    $supplier_id = mysqli_insert_id($conn);
}

// حساب إجمالي الفاتورة من أسعار شراء القطعة × الكمية (يمكنك تغييره حسب منطقك)
if (isset($_POST['qty']) && is_array($_POST['qty'])) {
    foreach ($_POST['qty'] as $i => $qty) {
        $total += floatval($_POST['piece_buy_price'][$i]) * floatval($qty);
    }
}

// إدخال الفاتورة
mysqli_query($conn, "INSERT INTO purchases (supplier_id, supplier_name, total, paid, remain, notes, created_at)
    VALUES ($supplier_id, '', $total, $paid, ($total - $paid), '$notes', NOW())");
$purchase_id = mysqli_insert_id($conn);

// حفظ تفاصيل كل منتج
foreach ($_POST['qty'] as $i => $qty) {
    $pack_type         = isset($_POST['pack_type'][$i]) ? $_POST['pack_type'][$i] : 'piece';
    $qty               = intval($qty);
    $carton_buy_price  = isset($_POST['carton_buy_price'][$i]) ? floatval($_POST['carton_buy_price'][$i]) : 0;
    $carton_sell_price = isset($_POST['carton_sell_price'][$i]) ? floatval($_POST['carton_sell_price'][$i]) : 0;
    $piece_buy_price   = isset($_POST['piece_buy_price'][$i]) ? floatval($_POST['piece_buy_price'][$i]) : 0;
    $piece_sell_price  = isset($_POST['piece_sell_price'][$i]) ? floatval($_POST['piece_sell_price'][$i]) : 0;
    $carton_qty        = isset($_POST['carton_qty_val'][$i]) ? intval($_POST['carton_qty_val'][$i]) : 0;
    $product_id        = isset($_POST['product_id'][$i]) ? intval($_POST['product_id'][$i]) : 0;
    $product_name      = isset($_POST['new_product'][$i]) ? trim($_POST['new_product'][$i]) : '';

    // القيم الأساسية المطلوبة للكاشير
    $price_wholesale = $carton_sell_price; // يمكنك تغيير هذا المنطق حسب سياستك
    $price_retail    = $piece_sell_price;

    // إذا المنتج جديد
    if ($product_id == 0 && $product_name != "") {
        // التحقق من كل القيم
        if ($carton_qty <= 0 || $piece_buy_price <= 0 || $piece_sell_price <= 0) {
            die("يجب تعبئة جميع بيانات المنتج الجديد بشكل صحيح.");
        }

        mysqli_query($conn, "INSERT INTO products 
            (name, price_wholesale, price_retail, carton_qty, carton_buy_price, carton_sell_price, piece_buy_price, piece_sell_price, stock)
            VALUES (
                '" . mysqli_real_escape_string($conn, $product_name) . "',
                $price_wholesale,
                $price_retail,
                $carton_qty,
                $carton_buy_price,
                $carton_sell_price,
                $piece_buy_price,
                $piece_sell_price,
                $qty
            )");
        $product_id = mysqli_insert_id($conn);
    } else if($product_id > 0) {
        // منتج قديم: إذا كان أي من القيم الأساسية = 0 قم بتحديثها
        $get = mysqli_query($conn, "SELECT * FROM products WHERE id = $product_id");
        $prod = mysqli_fetch_assoc($get);
        $upd = [];
        if ($prod['price_wholesale'] <= 0 && $carton_sell_price > 0) $upd[] = "price_wholesale = $carton_sell_price";
        if ($prod['price_retail']    <= 0 && $piece_sell_price  > 0) $upd[] = "price_retail = $piece_sell_price";
        if ($prod['carton_qty']      <= 0 && $carton_qty        > 0) $upd[] = "carton_qty = $carton_qty";
        if ($prod['carton_buy_price']<= 0 && $carton_buy_price  > 0) $upd[] = "carton_buy_price = $carton_buy_price";
        if ($prod['carton_sell_price']<= 0 && $carton_sell_price > 0) $upd[] = "carton_sell_price = $carton_sell_price";
        if ($prod['piece_buy_price'] <= 0 && $piece_buy_price   > 0) $upd[] = "piece_buy_price = $piece_buy_price";
        if ($prod['piece_sell_price']<= 0 && $piece_sell_price  > 0) $upd[] = "piece_sell_price = $piece_sell_price";
        if (count($upd)) {
            mysqli_query($conn, "UPDATE products SET " . implode(", ", $upd) . " WHERE id = $product_id");
        }
        // تحديث المخزون
        mysqli_query($conn, "UPDATE products SET stock = stock + $qty WHERE id = $product_id");
    }

    // حفظ تفاصيل الفاتورة في purchases_items
    $unit_price = $piece_buy_price > 0 ? $piece_buy_price : $carton_buy_price;
    $total_line = $qty * $unit_price;
    mysqli_query($conn, "INSERT INTO purchases_items (purchase_id, product_id, pack_type, carton_qty, qty, unit_price, total)
        VALUES ($purchase_id, $product_id, '$pack_type', $carton_qty, $qty, $unit_price, $total_line)");
}

header('Location: purchases.php?added=1');
exit;
?>
