<?php
include('config.php');

// تجهيز الفلاتر (بدون prepared)
$where = "1";
if (isset($_GET['product_name']) && trim($_GET['product_name']) != '') {
    $product_name = mysqli_real_escape_string($conn, $_GET['product_name']);
    $where .= " AND p.name LIKE '%$product_name%'";
} else {
    $product_name = '';
}

$from_date = isset($_GET['from_date']) ? $_GET['from_date'] : '';
$to_date = isset($_GET['to_date']) ? $_GET['to_date'] : '';

if ($from_date && $to_date) {
    $where .= " AND DATE(s.created_at) BETWEEN '$from_date' AND '$to_date'";
} elseif ($from_date) {
    $where .= " AND DATE(s.created_at) >= '$from_date'";
} elseif ($to_date) {
    $where .= " AND DATE(s.created_at) <= '$to_date'";
}

$sql = "
SELECT
    p.id AS product_id,
    p.name AS product_name,
    pi.qty AS entered_qty,
    pi.pack_type AS entry_type,
    pi.unit_price AS buy_price,
    si.qty AS sold_qty,
    si.unit_price AS sold_unit_price,
    si.total AS sold_total,
    si.pack_type AS sold_type,
    s.created_at AS sale_date,
    p.carton_buy_price,
    p.carton_sell_price
FROM products p
LEFT JOIN purchases_items pi ON p.id = pi.product_id
LEFT JOIN sales_items si ON p.id = si.product_id
LEFT JOIN sales s ON s.id = si.sale_id
WHERE $where
ORDER BY p.id, s.created_at
";
$res = mysqli_query($conn, $sql);

// حساب المجاميع
$total_sales_sum = 0;
$total_profit_sum = 0;
$total_sold_qty = 0;
$total_entered_qty = 0;

$data = array();
while ($row = mysqli_fetch_assoc($res)) {
    // حساب الربح
    if (isset($row['sold_type']) && $row['sold_type'] == 'carton') {
        $carton_sell = isset($row['carton_sell_price']) ? $row['carton_sell_price'] : 0;
        $carton_buy = isset($row['carton_buy_price']) ? $row['carton_buy_price'] : 0;
        $sold_qty = isset($row['sold_qty']) ? $row['sold_qty'] : 0;
        $profit = ($carton_sell - $carton_buy) * $sold_qty;
    } elseif (isset($row['sold_type']) && $row['sold_type'] == 'piece') {
        $sold_unit_price = isset($row['sold_unit_price']) ? $row['sold_unit_price'] : 0;
        $buy_price = isset($row['buy_price']) ? $row['buy_price'] : 0;
        $sold_qty = isset($row['sold_qty']) ? $row['sold_qty'] : 0;
        $profit = ($sold_unit_price - $buy_price) * $sold_qty;
    } else {
        $profit = 0;
    }

    $total_sales_sum  += isset($row['sold_total']) ? $row['sold_total'] : 0;
    $total_profit_sum += $profit;
    $total_sold_qty   += isset($row['sold_qty']) ? $row['sold_qty'] : 0;
    $total_entered_qty+= isset($row['entered_qty']) ? $row['entered_qty'] : 0;

    $row['profit'] = $profit;
    $data[] = $row;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تقرير مفصل للمنتجات</title>
    <style>
        body { background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; background: #fff; margin-top: 25px; }
        th, td { border: 1px solid #dbe2e8; padding: 8px 6px; text-align: center; }
        th { background: #e3e9f2; }
        tr:nth-child(even) { background: #f3f7fa; }
        .summary-row {background:#e3f6e8; font-weight:bold;}
        .filter-bar {background: #fff; padding: 16px 22px; border-radius: 12px; max-width:900px; margin: 24px auto 0; box-shadow: 0 3px 20px #dbe7f385; display: flex; gap:18px; align-items: flex-end;}
        .filter-bar label {font-weight:bold;}
        .filter-bar input, .filter-bar select {padding: 7px 10px; border-radius: 7px; border:1px solid #dbe2e8;}
        .summary-group {display:flex; gap:24px; justify-content:center; margin:36px 0 0;}
        .summary-box {background:#fff; border-radius:14px; padding: 17px 28px; font-size:1.16rem; min-width:150px; box-shadow: 0 1px 10px #dae4ec59;}
        .summary-box span {font-size:1.22rem; font-weight:bold; color:#16633a;}
    </style>
</head>
<body>
    <h2 style="text-align:center;">تقرير مفصل للمنتجات</h2>

    <!-- شريط الفلترة -->
    <form method="get" class="filter-bar">
        <div>
            <label>اسم المنتج:</label><br>
            <input type="text" name="product_name" value="<?php echo htmlspecialchars($product_name); ?>" placeholder="بحث باسم المنتج">
        </div>
        <div>
            <label>من تاريخ:</label><br>
            <input type="date" name="from_date" value="<?php echo htmlspecialchars($from_date); ?>">
        </div>
        <div>
            <label>إلى تاريخ:</label><br>
            <input type="date" name="to_date" value="<?php echo htmlspecialchars($to_date); ?>">
        </div>
        <button type="submit" style="padding:8px 22px; border-radius:8px; border:0; background:#1976d2; color:#fff; font-size:1.12rem;">تصفية</button>
        <a href="report_products.php" style="padding:8px 16px; border-radius:8px; border:0; background:#aaa; color:#fff; text-decoration:none; font-size:1.12rem;">إلغاء</a>
    </form>

    <table>
        <tr>
            <th>اسم المنتج</th>
            <th>الكمية الداخلة</th>
            <th>طريقة الإدخال</th>
            <th>تاريخ البيع</th>
            <th>نوع البيع</th>
            <th>الكمية المباعة</th>
            <th>سعر بيع القطعة</th>
            <th>سعر البيع للكمية</th>
            <th>الربح</th>
        </tr>
        <?php if($data): ?>
            <?php foreach($data as $row): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                <td><?php echo isset($row['entered_qty']) ? $row['entered_qty'] : ''; ?></td>
                <td><?php 
                    echo isset($row['entry_type']) && $row['entry_type'] == 'carton' ? 'كارتون' : 
                         (isset($row['entry_type']) && $row['entry_type'] == 'piece' ? 'قطعة' : '—'); 
                ?></td>
                <td><?php echo isset($row['sale_date']) && $row['sale_date'] ? date('Y-m-d', strtotime($row['sale_date'])) : '—'; ?></td>
                <td><?php 
                    echo isset($row['sold_type']) && $row['sold_type'] == 'carton' ? 'كارتون' : 
                         (isset($row['sold_type']) && $row['sold_type'] == 'piece' ? 'قطعة' : '—'); 
                ?></td>
                <td><?php echo isset($row['sold_qty']) ? $row['sold_qty'] : ''; ?></td>
                <td><?php echo isset($row['sold_unit_price']) ? number_format($row['sold_unit_price'], 2) : ''; ?></td>
                <td><?php echo isset($row['sold_total']) ? number_format($row['sold_total'], 2) : ''; ?></td>
                <td><?php echo number_format($row['profit'], 2); ?></td>
            </tr>
            <?php endforeach; ?>
            <!-- صف المجاميع النهائية -->
            <tr class="summary-row">
                <td>المجاميع:</td>
                <td><?php echo $total_entered_qty; ?></td>
                <td>—</td>
                <td>—</td>
                <td>—</td>
                <td><?php echo $total_sold_qty; ?></td>
                <td>—</td>
                <td><?php echo number_format($total_sales_sum, 2); ?></td>
                <td><?php echo number_format($total_profit_sum, 2); ?></td>
            </tr>
        <?php else: ?>
            <tr>
                <td colspan="9">لا توجد بيانات للعرض</td>
            </tr>
        <?php endif; ?>
    </table>

    <!-- صندوق المجاميع بشكل جميل -->
    <div class="summary-group">
        <div class="summary-box">
            مجموع الكمية الداخلة<br>
            <span><?php echo $total_entered_qty; ?></span>
        </div>
        <div class="summary-box">
            مجموع الكمية المباعة<br>
            <span><?php echo $total_sold_qty; ?></span>
        </div>
        <div class="summary-box">
            مجموع سعر البيع للكمية<br>
            <span><?php echo number_format($total_sales_sum, 2); ?></span>
        </div>
        <div class="summary-box">
            مجموع الربح<br>
            <span><?php echo number_format($total_profit_sum, 2); ?></span>
        </div>
    </div>
</body>
</html>
