<?php
include('config.php');

// متغير لحفظ المنتج المضاف حديثاً
$selected_product_id = isset($_GET['selected_product_id']) ? intval($_GET['selected_product_id']) : 0;

// إضافة مورد جديد
if (isset($_POST['new_supplier_name']) && trim($_POST['new_supplier_name']) != '') {
    $new_supplier_name = mysqli_real_escape_string($conn, trim($_POST['new_supplier_name']));
    mysqli_query($conn, "INSERT INTO suppliers (name) VALUES ('$new_supplier_name')");
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

// إضافة منتج جديد ككارتون أو قطع
if (isset($_POST['new_product_name']) && trim($_POST['new_product_name']) != '') {
    $new_product_name = mysqli_real_escape_string($conn, trim($_POST['new_product_name']));
    $new_pack_type = isset($_POST['new_pack_type']) ? $_POST['new_pack_type'] : 'carton';
    $new_carton_qty = (isset($_POST['new_carton_qty']) && intval($_POST['new_carton_qty']) > 0) ? intval($_POST['new_carton_qty']) : 1;
    $new_barcode = isset($_POST['new_barcode']) ? mysqli_real_escape_string($conn, trim($_POST['new_barcode'])) : NULL;

    $sql = "INSERT INTO products (name, carton_qty, pack_type, cartons_available, stock, barcode)
            VALUES ('$new_product_name', $new_carton_qty, '$new_pack_type', 0, 0, ".($new_barcode ? "'$new_barcode'" : "NULL").")";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $new_product_id = mysqli_insert_id($conn);
        header("Location: ".$_SERVER['PHP_SELF']."?selected_product_id=$new_product_id");
        exit;
    } else {
        echo "<div style='color:red;'>حدث خطأ أثناء إضافة المنتج: ".mysqli_error($conn)."</div>";
    }
}

// جلب الموردين
$suppliers = [];
$res = mysqli_query($conn, "SELECT * FROM suppliers");
while ($row = mysqli_fetch_assoc($res)) $suppliers[] = $row;

// جلب المنتجات
$products = [];
$res = mysqli_query($conn, "SELECT * FROM products");
while ($row = mysqli_fetch_assoc($res)) $products[] = $row;

// معالجة إضافة فاتورة الشراء
$msg = '';
if (
    isset($_POST['supplier_id']) &&
    isset($_POST['product_id']) &&
    (
        isset($_POST['carton_qty_input']) || isset($_POST['piece_qty_input'])
    ) &&
    !isset($_POST['new_product_name']) &&
    !isset($_POST['new_supplier_name'])
) {
    $supplier_id = intval($_POST['supplier_id']);
    $product_id  = intval($_POST['product_id']);
    $prod_row = mysqli_fetch_assoc(mysqli_query($conn, "SELECT carton_qty, pack_type FROM products WHERE id=$product_id"));
    $carton_qty = isset($prod_row['carton_qty']) ? intval($prod_row['carton_qty']) : 1;
    $pack_type = isset($prod_row['pack_type']) ? $prod_row['pack_type'] : 'carton';

    $qty = ($pack_type == 'carton')
        ? intval($_POST['carton_qty_input'])
        : intval($_POST['piece_qty_input']);

    $unit_price  = isset($_POST['unit_price']) ? floatval($_POST['unit_price']) : 0;
    $carton_sell_price = isset($_POST['carton_sell_price']) ? floatval($_POST['carton_sell_price']) : 0;
    $piece_sell_price  = isset($_POST['piece_sell_price'])  ? floatval($_POST['piece_sell_price'])  : 0;
    $total       = isset($_POST['total']) ? floatval($_POST['total']) : 0;
    $paid        = isset($_POST['paid']) ? floatval($_POST['paid']) : 0;
    $remain      = isset($_POST['remain']) ? floatval($_POST['remain']) : 0;
    $notes       = isset($_POST['notes']) ? trim($_POST['notes']) : '';

    mysqli_query($conn, "INSERT INTO purchases (supplier_id, total, paid, remain, notes) 
        VALUES ($supplier_id, $total, $paid, $remain, '$notes')");
    $purchase_id = mysqli_insert_id($conn);

    mysqli_query($conn, "INSERT INTO purchases_items (purchase_id, product_id, pack_type, carton_qty, qty, unit_price, total) 
        VALUES ($purchase_id, $product_id, '$pack_type', $carton_qty, $qty, $unit_price, $total)");

    if ($pack_type == 'carton') {
        $total_pieces = $qty * $carton_qty;
        mysqli_query($conn, "UPDATE products 
            SET stock = stock + $total_pieces, 
                cartons_available = cartons_available + $qty 
            WHERE id = $product_id");
    } else {
        mysqli_query($conn, "UPDATE products SET stock = stock + $qty WHERE id = $product_id");
    }

    mysqli_query($conn, "UPDATE products SET 
        carton_sell_price = $carton_sell_price, 
        piece_sell_price = $piece_sell_price 
        WHERE id = $product_id
    ");

    if ($total > 0) {
        $notes_sql = mysqli_real_escape_string($conn, $notes);
        mysqli_query($conn, "INSERT INTO supplier_transactions (supplier_id, trans_type, amount, notes) VALUES ($supplier_id, 'purchase', $total, '$notes_sql')");
    }
    if ($paid > 0) {
        $notes_sql = mysqli_real_escape_string($conn, $notes);
        mysqli_query($conn, "INSERT INTO supplier_transactions (supplier_id, trans_type, amount, notes) VALUES ($supplier_id, 'payment', $paid, '$notes_sql')");
    }

    $msg = "<div id='success-msg' style='padding:15px;background:#c6f7c6;color:#256029;border-radius:7px;margin:20px 0;transition:0.6s;'>تمت إضافة فاتورة الشراء بنجاح!</div>";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة فاتورة شراء جديدة</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 700px; margin: 30px auto; background: #fff; border-radius: 20px; box-shadow: 0 5px 30px #dbe7f380; padding: 34px;}
        h2 {color: #1976d2; font-size: 2rem; text-align:center; margin-bottom:22px;}
        label {display:block;margin-bottom:7px;font-weight:600;}
        select, input, textarea {width:100%;padding:9px 8px;margin-bottom:15px;border:1px solid #dbe2e8;border-radius:7px;font-size:1.05rem;}
        .row {display:flex;gap:10px;}
        .row > div {flex:1;}
        .hide {display:none;}
        button {background:#1976d2;color:#fff;border:0;padding:11px 30px;border-radius:8px;font-size:1.1rem;cursor:pointer;}
        .add-btn {background:#fff;color:#1976d2;border:1px solid #1976d2;margin-bottom: 10px;}
        .actions-bar {display: flex; gap: 15px; margin-bottom: 12px;}
        .barcode-group {display: flex;align-items: center;gap: 8px;margin-top: 10px;}
        .barcode-group input {flex:1;}
        .barcode-btn {padding:9px 13px;background:#1976d2;color:#fff;border:none;border-radius:8px;font-weight:bold;cursor:pointer;}
        .barcode-btn:hover {background:#14509c;}
        #barcodeCameraBox {display:none; margin-top: 8px;}
        #barcodeCamera {width: 100%; max-width: 350px; margin:0 auto; border-radius:13px; overflow:hidden;}
        #closeBarcodeCamera {margin-top:6px;background:#e74c3c;color:#fff;padding:6px 19px;border:none;border-radius:7px;}
        .barcode-info {font-size:13px; color:#888; margin-top:3px;}
    </style>
</head>
<body>
<div class="container">
    <h2>إضافة فاتورة شراء جديدة</h2>
    <?php if ($msg) echo $msg; ?>

    <div class="actions-bar">
        <!-- زر إضافة مورد جديد -->
        <form method="post" style="margin-bottom:0;">
            <button type="button" class="add-btn" onclick="document.getElementById('new_supplier_box').style.display='block';">+ إضافة مورد جديد</button>
            <div id="new_supplier_box" class="hide">
                <input type="text" id="new_supplier_name" name="new_supplier_name" placeholder="اسم المورد الجديد" required>
                <button type="submit" class="add-btn">حفظ المورد</button>
            </div>
        </form>
        <!-- زر إضافة منتج جديد -->
        <form method="post" id="add_product_form" style="margin-bottom:0;">
            <button type="button" class="add-btn" onclick="document.getElementById('new_product_box').style.display='block';showNewProductFields();">+ إضافة منتج جديد</button>
            <div id="new_product_box" class="hide" style="background: #f7fbff; border-radius: 15px; padding: 24px 17px 13px 17px; margin-top:10px;">
                <input type="text" id="new_product_name" name="new_product_name" placeholder="اسم المنتج الجديد" required style="font-size:1.13rem;">
                <div style="margin-top:8px;display:flex;gap:15px;">
                    <label style="font-size:1rem;">
                        <input type="radio" name="new_pack_type" value="carton" checked onchange="showNewProductFields();"> كارتون
                    </label>
                    <label style="font-size:1rem;">
                        <input type="radio" name="new_pack_type" value="piece" onchange="showNewProductFields();"> قطع
                    </label>
                </div>
                <div id="carton_qty_box" style="margin-top:6px;">
                    <input type="number" id="new_carton_qty" name="new_carton_qty" min="1" placeholder="عدد القطع في الكارتون" value="1" required>
                </div>
                <!-- حقل الباركود مع زر الكاميرا -->
                <div class="barcode-group">
                    <input type="text" id="new_barcode" name="new_barcode" placeholder="امسح أو أدخل الباركود" style="padding:9px 17px;font-size:1.08rem;border-radius:8px;border:1px solid #bcd6e4;direction:ltr;">
                    <button type="button" id="barcodeCameraBtn" class="barcode-btn"><i class="fa fa-camera"></i></button>
                </div>
                <div id="barcodeCameraBox">
                    <div id="barcodeCamera"></div>
                    <button type="button" id="closeBarcodeCamera"><i class="fa fa-times"></i> إغلاق الكاميرا</button>
                </div>
                <div class="barcode-info">* يمكنك تركه فارغ إذا المنتج بدون باركود</div>
                <button type="submit" class="add-btn" style="margin-top:17px;width:100%;">حفظ المنتج</button>
            </div>
        </form>
    </div>

    <!-- النموذج الرئيسي للشراء -->
    <form method="post" autocomplete="off">
        <label>اسم المورد</label>
        <select name="supplier_id" required>
            <option value="">اختر المورد</option>
            <?php foreach($suppliers as $s): ?>
                <option value="<?php echo $s['id']; ?>" <?php if(isset($_POST['supplier_id']) && $_POST['supplier_id']==$s['id']) echo "selected"; ?>>
                    <?php echo htmlspecialchars($s['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <label>اسم المنتج</label>
        <select name="product_id" id="product_id" required onchange="updateMainFormFields();">
            <option value="">اختر المنتج</option>
            <?php foreach($products as $p): ?>
                <option value="<?php echo $p['id']; ?>" <?php
                    if(($selected_product_id && $p['id'] == $selected_product_id) || (isset($_POST['product_id']) && $_POST['product_id']==$p['id'])) echo "selected";
                ?>>
                    <?php echo htmlspecialchars($p['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <!-- حقول الكارتون -->
        <div id="carton_main_fields" style="display:none;">
            <label>عدد الكراتين</label>
            <input type="number" name="carton_qty_input" min="1" value="1" required oninput="calcTotal()">
            <label>سعر شراء الكارتون</label>
            <input type="number" step="0.01" name="unit_price" value="0" required oninput="calcTotal()">
            <label>سعر بيع الكارتون</label>
            <input type="number" step="0.01" name="carton_sell_price" value="0" required>
        </div>

        <!-- حقول القطع -->
        <div id="piece_main_fields" style="display:none;">
            <label>عدد القطع</label>
            <input type="number" name="piece_qty_input" min="1" value="1" oninput="calcTotal()">
            <label>سعر شراء القطعة</label>
            <input type="number" step="0.01" name="unit_price" value="0" oninput="calcTotal()">
            <label>سعر بيع القطعة</label>
            <input type="number" step="0.01" name="piece_sell_price" value="0">
        </div>

        <label>إجمالي الفاتورة</label>
        <input type="text" name="total" readonly required>

        <div class="row">
            <div>
                <label>المدفوع للمورد</label>
                <input type="number" step="0.01" name="paid" value="0" required oninput="calcTotal()">
            </div>
            <div>
                <label>المتبقي على المورد (دين)</label>
                <input type="text" name="remain" readonly required>
            </div>
        </div>

        <label>ملاحظات</label>
        <textarea name="notes" rows="2"></textarea>

        <button type="submit" style="width:100%;margin-top:12px;">إضافة الفاتورة</button>
    </form>
</div>

<script>
    var productsData = <?php echo json_encode($products, JSON_UNESCAPED_UNICODE); ?>;

    function showNewProductFields() {
        var type = document.querySelector('input[name="new_pack_type"]:checked').value;
        var qtyInput = document.getElementById('new_carton_qty');
        var qtyBox = document.getElementById('carton_qty_box');
        if (type === 'carton') {
            qtyBox.style.display = 'block';
            qtyInput.required = true;
            qtyInput.value = '';
        } else {
            qtyBox.style.display = 'none';
            qtyInput.value = 1;
            qtyInput.required = false;
        }
    }

    function updateMainFormFields() {
        var productId = document.getElementById('product_id').value;
        var found = productsData.find(function(p){ return p.id == productId; });
        if (!found) {
            document.getElementById('carton_main_fields').style.display = 'none';
            document.getElementById('piece_main_fields').style.display = 'none';
            return;
        }
        if (found.pack_type == 'carton') {
            document.getElementById('carton_main_fields').style.display = 'block';
            document.getElementById('piece_main_fields').style.display = 'none';
        } else {
            document.getElementById('carton_main_fields').style.display = 'none';
            document.getElementById('piece_main_fields').style.display = 'block';
        }
        calcTotal();
    }

    function calcTotal() {
        var cartonFields = document.getElementById('carton_main_fields').style.display != 'none';
        var qty = 1, price = 0;
        if (cartonFields) {
            qty = parseFloat(document.querySelector('div#carton_main_fields input[name="carton_qty_input"]').value) || 0;
            price = parseFloat(document.querySelector('div#carton_main_fields input[name="unit_price"]').value) || 0;
        } else {
            qty = parseFloat(document.querySelector('div#piece_main_fields input[name="piece_qty_input"]').value) || 0;
            price = parseFloat(document.querySelector('div#piece_main_fields input[name="unit_price"]').value) || 0;
        }
        document.querySelector('input[name="total"]').value = (qty * price).toFixed(2);

        var paid = parseFloat(document.querySelector('input[name="paid"]').value) || 0;
        var total = parseFloat(document.querySelector('input[name="total"]').value) || 0;
        document.querySelector('input[name="remain"]').value = (total - paid).toFixed(2);
    }

    // كاميرا الباركود
    var barcodeCameraStarted = false;
    var barcodeQrcode = null;
    var barcodeCameraBox = document.getElementById('barcodeCameraBox');
    var barcodeBtn = document.getElementById('barcodeCameraBtn');
    var closeBarcodeCamera = document.getElementById('closeBarcodeCamera');
    barcodeBtn.onclick = function() {
        if (barcodeCameraStarted) return;
        barcodeCameraBox.style.display = "block";
        barcodeQrcode = new Html5Qrcode("barcodeCamera");
        barcodeQrcode.start(
            { facingMode: "environment" },
            { fps: 10, qrbox: 200 },
            function(decodedText, decodedResult) {
                document.getElementById('new_barcode').value = decodedText;
                stopBarcodeCamera();
            },
            function(errorMessage) { /* تجاهل الأخطاء */ }
        ).then(()=>{ barcodeCameraStarted = true; }).catch(()=>{
            barcodeCameraBox.style.display = "none";
            barcodeCameraStarted = false;
            alert('لم تنجح محاولة فتح الكاميرا');
        });
    };
    function stopBarcodeCamera() {
        if (barcodeQrcode) {
            barcodeQrcode.stop().then(()=>{
                barcodeCameraBox.style.display = "none";
                barcodeCameraStarted = false;
            }).catch(()=>{});
        }
    }
    closeBarcodeCamera.onclick = stopBarcodeCamera;

    window.onload = function(){
        showNewProductFields();
        updateMainFormFields();
        var msg = document.getElementById('success-msg');
        if (msg) setTimeout(function(){ msg.style.display='none'; }, 3000);
        calcTotal();
    }
</script>
</body>
</html>
