<?php
include('config.php');

// استلام رقم الفاتورة
$sale_id = isset($_GET['sale_id']) ? intval($_GET['sale_id']) : 0;

// جلب بيانات الفاتورة
$sql = "SELECT * FROM sales WHERE id = $sale_id LIMIT 1";
$res = mysqli_query($conn, $sql);
$sale = mysqli_fetch_assoc($res);

// جلب تفاصيل الفاتورة
$sql2 = "SELECT s.*, p.name FROM sales_items s
         JOIN products p ON s.product_id = p.id
         WHERE s.sale_id = $sale_id";
$res2 = mysqli_query($conn, $sql2);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>فاتورة رقم <?= $sale_id ?></title>
    <style>
        body { font-family: 'Cairo', Arial, sans-serif; background: #fff; }
        .invoice-box { max-width: 500px; margin: 45px auto; border: 1px solid #eee; border-radius: 18px; box-shadow: 0 4px 20px #eee; padding: 28px 22px;}
        h2 {text-align:center; color: #1976d2;}
        table { width: 100%; border-collapse: collapse; margin-top: 18px; }
        th, td { border-bottom: 1px solid #eee; padding: 7px 6px; text-align: center; }
        th { background: #e3f2fd; }
        .total-row td { font-weight: bold; font-size: 1.07em;}
        .print-btn { margin: 25px auto 0; display: block; background: #1976d2; color: #fff; border: none; padding: 9px 25px; border-radius: 10px; font-size: 1.12em; cursor: pointer;}
        @media print { .print-btn { display: none; } }
    </style>
</head>
<body>
<div class="invoice-box">
    <h2>فاتورة رقم <?= $sale_id ?></h2>
    <table>
        <tr>
            <th>الصنف</th>
            <th>الكمية</th>
            <th>سعر الوحدة</th>
            <th>المجموع</th>
        </tr>
        <?php $total = 0; while($item = mysqli_fetch_assoc($res2)): ?>
        <tr>
            <td><?= htmlspecialchars($item['name']) ?></td>
            <td><?= $item['qty'] ?></td>
            <td><?= $item['unit_price'] ?> د.ع</td>
            <td><?= $item['total'] ?> د.ع</td>
        </tr>
        <?php $total += $item['total']; endwhile; ?>
        <tr class="total-row">
            <td colspan="3">المجموع الكلي</td>
            <td><?= $sale['total'] ?> د.ع</td>
        </tr>
    </table>
    <div style="margin-top:14px; font-size:1.11em;">
        نوع الفاتورة: <b><?= $sale['sale_type'] == 'wholesale' ? 'جملة' : 'مفرد' ?></b>
        <br>
        تاريخ: <?= $sale['created_at'] ?>
    </div>
    <button class="print-btn" onclick="window.print()">طباعة الفاتورة</button>
</div>
</body>
</html>
