<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// جلب الأدوية لخيارات التصفية
$res_meds = mysqli_query($conn, "SELECT id, name FROM medicines ORDER BY name ASC");

// استلام الفلاتر
$from = isset($_GET['from']) ? $_GET['from'] : date('Y-m-01');
$to   = isset($_GET['to'])   ? $_GET['to']   : date('Y-m-d');
$product_id = isset($_GET['product_id']) && $_GET['product_id'] != '' ? intval($_GET['product_id']) : '';
$filter_sql = $product_id ? "WHERE m.id = $product_id" : "";

// إجمالي الفواتير
$sql_total = "SELECT COUNT(*) as total_invoices FROM sales WHERE sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59'";
$res_total = mysqli_query($conn, $sql_total);
$row_total = mysqli_fetch_assoc($res_total);

// إجمالي المبيعات (قبل المرتجع)
$sql_gross_sales = "
    SELECT IFNULL(SUM(si.total),0) AS gross_sales
    FROM sales_items si
    JOIN sales s ON si.sale_id = s.id
    WHERE s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59'
";
$res_gross_sales = mysqli_query($conn, $sql_gross_sales);
$row_gross_sales = mysqli_fetch_assoc($res_gross_sales);
$gross_sales = $row_gross_sales['gross_sales'];

// إجمالي المرتجعات
$sql_total_returns = "
    SELECT IFNULL(SUM(sri.quantity * sri.price),0) AS total_returns
    FROM sales_return_items sri
    JOIN sales_returns sr ON sri.sales_return_id = sr.id
    WHERE sr.return_date BETWEEN '$from 00:00:00' AND '$to 23:59:59'
";
$res_total_returns = mysqli_query($conn, $sql_total_returns);
$row_total_returns = mysqli_fetch_assoc($res_total_returns);
$total_returns = $row_total_returns['total_returns'];

// صافي المبيعات
$net_sales = $gross_sales - $total_returns;

// أكثر الأدوية مبيعًا (بعد خصم المرتجعات)
$sql_top = "
SELECT m.name,
    (
        (SELECT IFNULL(SUM(si.quantity),0) FROM sales_items si JOIN sales s ON si.sale_id = s.id WHERE si.medicine_id = m.id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
        -
        (SELECT IFNULL(SUM(sri.quantity),0) FROM sales_return_items sri JOIN sales_returns sr ON sri.sales_return_id = sr.id WHERE sri.product_id = m.id AND sr.return_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
    ) AS sold_qty,
    (
        (SELECT IFNULL(SUM(si.total),0) FROM sales_items si JOIN sales s ON si.sale_id = s.id WHERE si.medicine_id = m.id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
        -
        (SELECT IFNULL(SUM(sri.quantity * sri.price),0) FROM sales_return_items sri JOIN sales_returns sr ON sri.sales_return_id = sr.id WHERE sri.product_id = m.id AND sr.return_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
    ) AS total_value,
    m.id
FROM medicines m
ORDER BY sold_qty DESC
LIMIT 7
";
$res_top = mysqli_query($conn, $sql_top);

// IDs الأدوية الأكثر مبيعاً لاستبعادها من الأقل حركة
$top_ids = [];
if ($res_top && mysqli_num_rows($res_top) > 0) {
    mysqli_data_seek($res_top, 0);
    while($row = mysqli_fetch_assoc($res_top)) {
        $top_ids[] = intval($row['id']);
    }
}

// أقل الأدوية حركة مع استبعاد الأكثر مبيعًا (بعد خصم المرتجع)
$exclude_top = count($top_ids) ? "AND m.id NOT IN (" . implode(',', $top_ids) . ")" : '';
$sql_least = "
SELECT m.name,
    (
        (SELECT IFNULL(SUM(si.quantity),0) FROM sales_items si JOIN sales s ON si.sale_id = s.id WHERE si.medicine_id = m.id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
        -
        (SELECT IFNULL(SUM(sri.quantity),0) FROM sales_return_items sri JOIN sales_returns sr ON sri.sales_return_id = sr.id WHERE sri.product_id = m.id AND sr.return_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
    ) AS sold_qty
FROM medicines m
WHERE 1 $exclude_top
ORDER BY sold_qty ASC
LIMIT 7
";
$res_least = mysqli_query($conn, $sql_least);

// ملخص المنتجات والربح بعد خصم المرتجعات
$products_query = "
SELECT 
    m.id,
    m.name,
    m.price,
    m.cost_price,
    IFNULL(SUM(pu.quantity), 0) AS qty_in,
    (
        (SELECT IFNULL(SUM(si.quantity),0) FROM sales_items si JOIN sales s ON si.sale_id = s.id WHERE si.medicine_id = m.id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
        -
        (SELECT IFNULL(SUM(sri.quantity),0) FROM sales_return_items sri JOIN sales_returns sr ON sri.sales_return_id = sr.id WHERE sri.product_id = m.id AND sr.return_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
    ) AS qty_sold,
    (
        (
            (SELECT IFNULL(SUM(si.quantity),0) FROM sales_items si JOIN sales s ON si.sale_id = s.id WHERE si.medicine_id = m.id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
            -
            (SELECT IFNULL(SUM(sri.quantity),0) FROM sales_return_items sri JOIN sales_returns sr ON sri.sales_return_id = sr.id WHERE sri.product_id = m.id AND sr.return_date BETWEEN '$from 00:00:00' AND '$to 23:59:59')
        ) * (m.price - m.cost_price)
    ) AS profit,
    (
        SELECT MAX(s.sale_date) FROM sales_items si JOIN sales s ON si.sale_id = s.id WHERE si.medicine_id = m.id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59'
    ) AS last_sale_date
FROM medicines m
LEFT JOIN purchases pu ON pu.medicine_id = m.id
$filter_sql
GROUP BY m.id, m.name, m.price, m.cost_price
ORDER BY profit DESC
";
$res_products = mysqli_query($conn, $products_query);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تقارير المبيعات والإحصائيات</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {background: #f8faff; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 1100px; margin: 32px auto;}
        h1 {color: #1976d2; text-align:center;}
        form {display: flex; gap: 13px; justify-content:center; margin-bottom: 27px; flex-wrap: wrap;}
        input[type="date"], select {padding:7px 14px; border-radius: 8px; border: 1px solid #b2c5e7;}
        .m-btn {
            display: inline-flex; align-items: center; gap: 5px;
            padding: 9px 22px; border: 1.5px solid #b6cced;
            border-radius: 9px; font-weight: bold; font-size: 1.07rem;
            cursor: pointer; background: linear-gradient(90deg,#e5f7ff 80%,#f3fbff 100%);
            color: #0288d1; box-shadow: 0 1px 7px #e3eefd1c; transition: all .13s;
        }
        .m-btn svg {vertical-align: middle;}
        .m-btn:hover {background:linear-gradient(90deg,#cbefff 80%,#e2f6ff 100%);color:#015378;}
        .report-box {background: #fff; border-radius: 14px; box-shadow: 0 5px 22px #dbe8fd62; padding: 18px 25px; margin-bottom: 22px;}
        .stats {display: flex; gap: 24px; justify-content:center; margin-bottom:16px; flex-wrap: wrap;}
        .stat-card {background: #eaf1fb; border-radius: 10px; padding: 17px 22px; min-width: 170px; text-align: center;}
        .stat-title {color: #1976d2; font-weight:bold;}
        .stat-value {font-size: 1.6rem; color:#222; margin: 8px 0;}
        .stat-card.net {background: #d0ffe2;}
        .stat-card.net .stat-value {color:#08814d;}
        table {width: 100%; border-collapse: collapse; background: #fff;}
        th, td {padding: 10px; text-align: center; border-bottom: 1px solid #e3e3e3;}
        th {background: #eaf1fb;}
        .badge {background:#ffd500;color:#222;padding:2px 10px;border-radius:9px;font-weight:bold;font-size:.98rem;}
    </style>
</head>
<body>
    <div class="container">
        <h1>تقارير المبيعات والإحصائيات</h1>
        <form method="get">
            <label>من:</label>
            <input type="date" name="from" value="<?= htmlspecialchars($from) ?>">
            <label>إلى:</label>
            <input type="date" name="to" value="<?= htmlspecialchars($to) ?>">
            <label>اسم الدواء:</label>
            <select name="product_id">
                <option value="">كل الأدوية</option>
                <?php while($med = mysqli_fetch_assoc($res_meds)): ?>
                    <option value="<?= $med['id'] ?>" <?= ($product_id == $med['id']) ? 'selected' : '' ?>><?= htmlspecialchars($med['name']) ?></option>
                <?php endwhile; ?>
            </select>
            <button type="submit" class="m-btn">
                <svg width="18" height="18" viewBox="0 0 20 20"><circle cx="9" cy="9" r="6" stroke="#0288d1" stroke-width="1.7" fill="none"/><path d="M15 15l-3-3" stroke="#0288d1" stroke-width="1.7" stroke-linecap="round"/></svg>
                عرض التقرير
            </button>
        </form>
        <div class="report-box">
            <div class="stats">
                <div class="stat-card">
                    <div class="stat-title">عدد الفواتير</div>
                    <div class="stat-value"><?= $row_total['total_invoices'] ?: 0 ?></div>
                </div>
                <div class="stat-card">
                    <div class="stat-title">إجمالي المبيعات</div>
                    <div class="stat-value"><?= number_format($gross_sales,2) ?> د.ع</div>
                </div>
                <div class="stat-card">
                    <div class="stat-title">إجمالي المرتجعات</div>
                    <div class="stat-value"><?= number_format($total_returns,2) ?> د.ع</div>
                </div>
                <div class="stat-card net">
                    <div class="stat-title">صافي المبيعات</div>
                    <div class="stat-value"><?= number_format($net_sales,2) ?> د.ع</div>
                </div>
            </div>
        </div>
        <div class="report-box">
            <h3 style="color:#43a047;margin-bottom:7px;">أكثر الأدوية مبيعًا</h3>
            <table>
                <tr>
                    <th>اسم الدواء</th>
                    <th>الكمية المباعة</th>
                    <th>إجمالي المبيعات</th>
                </tr>
                <?php
                if ($res_top && mysqli_num_rows($res_top) > 0) {
                    mysqli_data_seek($res_top, 0);
                    while($row = mysqli_fetch_assoc($res_top)): ?>
                    <tr>
                        <td>
                            <span class="badge"><?= htmlspecialchars($row['name']) ?></span>
                        </td>
                        <td><?= max(0, $row['sold_qty']) ?></td>
                        <td><?= number_format($row['total_value'],2) ?> د.ع</td>
                    </tr>
                    <?php endwhile;
                } else { ?>
                    <tr><td colspan="3" style="color:#888;">لا توجد مبيعات كافية.</td></tr>
                <?php } ?>
            </table>
        </div>
        <div class="report-box">
            <h3 style="color:#d32f2f;margin-bottom:7px;">أقل الأدوية حركة</h3>
            <table>
                <tr>
                    <th>اسم الدواء</th>
                    <th>الكمية المباعة</th>
                </tr>
                <?php if ($res_least && mysqli_num_rows($res_least) > 0): ?>
                    <?php while($row = mysqli_fetch_assoc($res_least)): ?>
                    <tr>
                        <td>
                            <span class="badge"><?= htmlspecialchars($row['name']) ?></span>
                        </td>
                        <td><?= max(0, $row['sold_qty']) ?></td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="2" style="color:#888;">لا توجد مبيعات كافية.</td></tr>
                <?php endif; ?>
            </table>
        </div>
        <div class="report-box">
            <h3 style="color:#1976d2;margin-bottom:7px;">ملخص المنتجات والربح</h3>
            <table>
                <tr>
                    <th>اسم المنتج</th>
                    <th>الكمية المدخلة</th>
                    <th>الكمية المباعة</th>
                    <th>سعر البيع</th>
                    <th>سعر الشراء</th>
                    <th>إجمالي الربح</th>
                    <th>تاريخ آخر فاتورة بيع</th>
                </tr>
                <?php
                $total_in = 0;
                $total_sold = 0;
                $total_profit = 0;
                ?>
                <?php if ($res_products && mysqli_num_rows($res_products) > 0): ?>
                    <?php while($row = mysqli_fetch_assoc($res_products)):
                        $total_in += $row['qty_in'];
                        $total_sold += $row['qty_sold'];
                        $total_profit += $row['profit'];
                    ?>
                    <tr>
                        <td><span class="badge"><?= htmlspecialchars($row['name']) ?></span></td>
                        <td><?= $row['qty_in'] ?></td>
                        <td><?= max(0, $row['qty_sold']) ?></td>
                        <td><?= $row['price'] ?></td>
                        <td><?= $row['cost_price'] ?></td>
                        <td><?= number_format($row['profit']) ?> د.ع</td>
                        <td><?= $row['last_sale_date'] ? date('Y-m-d', strtotime($row['last_sale_date'])) : '-' ?></td>
                    </tr>
                    <?php endwhile; ?>
                    <tr style="background:#eaf1fb;font-weight:bold;">
                        <td>المجموع الكلي</td>
                        <td><?= $total_in ?></td>
                        <td><?= $total_sold ?></td>
                        <td colspan="2"></td>
                        <td><?= number_format($total_profit) ?> د.ع</td>
                        <td></td>
                    </tr>
                <?php else: ?>
                    <tr><td colspan="7" style="color:#888;">لا توجد بيانات منتجات.</td></tr>
                <?php endif; ?>
            </table>
        </div>
    </div>
</body>
</html>
