<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// جلب الموردين فقط مرة واحدة
$res_sup = mysqli_query($conn, "SELECT DISTINCT supplier FROM purchases WHERE supplier IS NOT NULL AND supplier != '' ORDER BY supplier ASC");
$suppliers = [];
while ($row = mysqli_fetch_assoc($res_sup)) $suppliers[] = $row['supplier'];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرتجع مشتريات المورد</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@700;600;400&display=swap" rel="stylesheet">
    <style>
        body { background: #f3f8fc; font-family: 'Cairo', Arial, sans-serif; min-height: 100vh; }
        .container { max-width: 620px; margin: 45px auto; background: #fff; border-radius: 19px; box-shadow: 0 8px 32px #b4daef49; padding: 36px 22px 30px 22px; }
        h1 { color: #1565c0; text-align: center; margin-bottom: 22px; letter-spacing: 1px; }
        .step { margin-bottom: 32px; }
        label { display: block; margin-bottom: 11px; color: #0a315b; font-weight: bold; }
        select, input[type="number"], input[type="text"] {
            width: 100%; padding: 13px; border-radius: 12px;
            border: 1.6px solid #b5cef8; margin-bottom: 10px;
            font-size: 1.12rem; background: #f6fafd; transition: border .18s;
        }
        select:focus, input:focus { border-color: #1976d2; outline: none; background: #e8f3fd; }
        .fancy-table { width: 100%; border-collapse: collapse; background: #fcfcff; margin-bottom: 12px; }
        .fancy-table th, .fancy-table td { padding: 10px 7px; text-align: center; border-bottom: 1px solid #e6ecf5; }
        .fancy-table th { background: #e8f2fc; font-weight: bold; }
        .card { background: #f1f9ff; border-radius: 12px; box-shadow: 0 3px 10px #e4eefc22; margin-bottom: 12px; padding: 15px 16px; display: flex; flex-wrap: wrap; align-items: center; justify-content: space-between;}
        .card-title { font-size: 1.06rem; font-weight: bold; color: #1565c0;}
        .hide {display:none;}
        .m-btn {
            padding: 11px 23px; border: none; border-radius: 10px;
            font-size: 1.14rem; font-weight: bold; color: #fff;
            background: linear-gradient(90deg, #1565c0 70%, #36a7f7 100%);
            box-shadow: 0 3px 9px #a2caf757; cursor: pointer; transition: background .16s;
            margin-top: 7px;
        }
        .m-btn:hover { background: linear-gradient(90deg, #1185d9 60%, #36a7f7 100%);}
        .success {background: #d2ffe2; color: #20874a; border-radius: 10px; padding: 10px 7px; text-align:center; margin-bottom:12px;}
        .error {background: #ffe7e7; color: #b91818; border-radius: 10px; padding: 10px 7px; text-align:center; margin-bottom:12px;}
        @media(max-width:600px) {.container{padding:10px;} select,input{font-size:1rem;}}
    </style>
</head>
<body>
<div class="container">
    <h1>مرتجع مشتريات المورد</h1>
    <div class="step" id="step1">
        <label for="supplier">اختر اسم المورد:</label>
        <select id="supplier" required>
            <option value="">-- اختر المورد --</option>
            <?php foreach($suppliers as $supplier): ?>
                <option value="<?= htmlspecialchars($supplier) ?>"><?= htmlspecialchars($supplier) ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="step hide" id="step2">
        <label for="purchase">اختر عملية الشراء:</label>
        <select id="purchase"></select>
    </div>

    <div class="step hide" id="step3">
        <form id="returnForm" autocomplete="off">
            <div id="purchaseInfo"></div>
            <label>الكمية المرجعة:</label>
            <input type="number" id="qty" min="1" required>
            <label>سبب المرتجع (اختياري):</label>
            <input type="text" id="reason" maxlength="150">
            <button type="submit" class="m-btn">تنفيذ المرتجع</button>
        </form>
        <div id="result"></div>
    </div>
</div>

<script>
document.getElementById('supplier').onchange = function() {
    let supplier = this.value;
    document.getElementById('step2').classList.add('hide');
    document.getElementById('step3').classList.add('hide');
    if (supplier) {
        fetch('ajax/get_purchases.php?supplier=' + encodeURIComponent(supplier))
            .then(res => res.json())
            .then(data => {
                let sel = document.getElementById('purchase');
                sel.innerHTML = '<option value="">-- اختر عملية الشراء --</option>';
                data.forEach(row => {
                    sel.innerHTML += `<option value="${row.id}" data-qty="${row.quantity}" data-price="${row.cost_price}" data-medicine="${row.medicine_name}">#${row.id} | ${row.medicine_name} | كمية: ${row.quantity} | سعر: ${row.cost_price} | ${row.purchase_date}</option>`;
                });
                document.getElementById('step2').classList.remove('hide');
            });
    }
};

document.getElementById('purchase').onchange = function() {
    let option = this.selectedOptions[0];
    if (!option.value) {
        document.getElementById('step3').classList.add('hide');
        return;
    }
    let qty = option.getAttribute('data-qty');
    let price = option.getAttribute('data-price');
    let med = option.getAttribute('data-medicine');
    document.getElementById('purchaseInfo').innerHTML =
        `<b>اسم الدواء:</b> ${med}<br><b>الكمية المتوفرة:</b> ${qty}<br><b>سعر الشراء:</b> ${price}`;
    document.getElementById('qty').setAttribute('max', qty);
    document.getElementById('step3').classList.remove('hide');
    document.getElementById('result').innerHTML = "";
};

document.getElementById('returnForm').onsubmit = function(e) {
    e.preventDefault();
    let purchase_id = document.getElementById('purchase').value;
    let qty = document.getElementById('qty').value;
    let reason = document.getElementById('reason').value;
    fetch('ajax/do_purchase_return.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `purchase_id=${purchase_id}&qty=${qty}&reason=${encodeURIComponent(reason)}`
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            document.getElementById('result').innerHTML = '<div class="success">'+data.message+'</div>';
        } else {
            document.getElementById('result').innerHTML = '<div class="error">'+data.message+'</div>';
        }
    });
};
</script>
</body>
</html>
