<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// جلب بيانات الدواء
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$sql = "SELECT * FROM medicines WHERE id = $id LIMIT 1";
$res = mysqli_query($conn, $sql);
if (!$res || mysqli_num_rows($res) == 0) {
    die("دواء غير موجود.");
}
$row = mysqli_fetch_assoc($res);

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $barcode    = isset($_POST['barcode']) ? trim($_POST['barcode']) : '';
    $name       = isset($_POST['name']) ? trim($_POST['name']) : '';
    $category   = isset($_POST['category']) ? trim($_POST['category']) : '';
    $price      = isset($_POST['price']) ? floatval($_POST['price']) : 0;
    $quantity   = isset($_POST['quantity']) ? intval($_POST['quantity']) : 0;
    $expiry     = isset($_POST['expiry_date']) ? trim($_POST['expiry_date']) : null;

    if ($name == '' || $price <= 0 || $quantity < 0) {
        $error = "يرجى إدخال اسم الدواء وسعر صحيح والكمية.";
    } else {
        $barcode_sql  = ($barcode == '') ? 'NULL' : "'".mysqli_real_escape_string($conn, $barcode)."'";
        $category_sql = ($category == '') ? 'NULL' : "'".mysqli_real_escape_string($conn, $category)."'";
        $expiry_sql   = ($expiry == '' || $expiry == null) ? 'NULL' : "'".mysqli_real_escape_string($conn, $expiry)."'";
        $name_sql     = mysqli_real_escape_string($conn, $name);

        $sql = "UPDATE medicines SET 
            barcode = $barcode_sql,
            name = '$name_sql',
            category = $category_sql,
            price = $price,
            quantity = $quantity,
            expiry_date = $expiry_sql
            WHERE id = $id
        ";
        if (mysqli_query($conn, $sql)) {
            $success = "تم تحديث بيانات الدواء بنجاح!";
            // جلب البيانات الجديدة بعد التحديث
            $res = mysqli_query($conn, "SELECT * FROM medicines WHERE id = $id LIMIT 1");
            $row = mysqli_fetch_assoc($res);
        } else {
            $error = "حدث خطأ أثناء تحديث بيانات الدواء!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تعديل دواء</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 430px; margin: 65px auto; background: #fff; border-radius: 18px; box-shadow: 0 5px 28px #dbe7f380; padding: 38px 32px;}
        h2 {text-align: center; color: #1976d2;}
        .msg {text-align: center; font-size: 1.1rem;}
        .msg.error {color: #d32f2f;}
        .msg.success {color: #43a047;}
        form {margin-top: 22px;}
        .input-group {margin-bottom: 18px;}
        label {display: block; margin-bottom: 7px; font-weight: bold;}
        input[type="text"], input[type="number"], input[type="date"] {
            width: 100%; padding: 9px; border-radius: 7px; border: 1px solid #ccc;
        }
        .btn {width: 100%; background: #1976d2; color: #fff; padding: 13px; border: none; border-radius: 9px; font-size: 1.09rem; font-weight: bold; cursor: pointer;}
        .back-btn {display: block; margin: 0 auto 22px auto; width: 100px; background: #888;}
    </style>
</head>
<body>
    <div class="container">
        <h2>تعديل بيانات دواء</h2>
        <?php if ($error): ?>
            <div class="msg error"><?= htmlspecialchars($error) ?></div>
        <?php elseif ($success): ?>
            <div class="msg success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="input-group">
                <label>الباركود <span style="color:#888;font-weight:normal;">(اختياري)</span></label>
                <input type="text" name="barcode" maxlength="50" value="<?= htmlspecialchars($row['barcode']) ?>">
            </div>
            <div class="input-group">
                <label>اسم الدواء</label>
                <input type="text" name="name" required value="<?= htmlspecialchars($row['name']) ?>">
            </div>
            <div class="input-group">
                <label>التصنيف <span style="color:#888;font-weight:normal;">(اختياري)</span></label>
                <input type="text" name="category" value="<?= htmlspecialchars($row['category']) ?>">
            </div>
            <div class="input-group">
                <label>السعر</label>
                <input type="number" step="0.01" name="price" required value="<?= htmlspecialchars($row['price']) ?>">
            </div>
            <div class="input-group">
                <label>الكمية</label>
                <input type="number" name="quantity" min="0" required value="<?= htmlspecialchars($row['quantity']) ?>">
            </div>
            <div class="input-group">
                <label>تاريخ الانتهاء <span style="color:#888;font-weight:normal;">(اختياري)</span></label>
                <input type="date" name="expiry_date" value="<?= htmlspecialchars($row['expiry_date']) ?>">
            </div>
            <button type="submit" class="btn">تحديث البيانات</button>
        </form>
        <a href="medicines.php" class="btn back-btn">رجوع</a>
    </div>
</body>
</html>
