<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// جلب كل الأدوية لاستخدامهم كبدائل
$medicines_alt = [];
$res_alt = mysqli_query($conn, "SELECT id, name FROM medicines ORDER BY name ASC");
while ($row = mysqli_fetch_assoc($res_alt)) {
    $medicines_alt[] = $row;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $barcode     = isset($_POST['barcode']) ? trim($_POST['barcode']) : '';
    $name        = isset($_POST['name']) ? trim($_POST['name']) : '';
    $category    = isset($_POST['category']) ? trim($_POST['category']) : '';
    $price       = isset($_POST['price']) ? floatval($_POST['price']) : 0;
    $cost_price  = isset($_POST['cost_price']) ? floatval($_POST['cost_price']) : 0;
    $quantity    = isset($_POST['quantity']) ? intval($_POST['quantity']) : 0;
    $expiry      = isset($_POST['expiry_date']) ? trim($_POST['expiry_date']) : null;
    $supplier    = isset($_POST['supplier']) ? trim($_POST['supplier']) : '';
    $paid_amount = isset($_POST['paid_amount']) ? floatval($_POST['paid_amount']) : 0;
    $notes       = isset($_POST['notes']) ? trim($_POST['notes']) : '';
    $location    = isset($_POST['location']) ? trim($_POST['location']) : '';
    $alternatives = isset($_POST['alternatives']) ? $_POST['alternatives'] : [];

    if ($name == '' || $price <= 0 || $quantity < 0 || $cost_price < 0) {
        $error = "يرجى إدخال اسم الدواء وسعر البيع وسعر الشراء بشكل صحيح والكمية.";
    } else {
        $barcode_sql  = ($barcode == '') ? 'NULL' : "'".mysqli_real_escape_string($conn, $barcode)."'";
        $category_sql = ($category == '') ? 'NULL' : "'".mysqli_real_escape_string($conn, $category)."'";
        $expiry_sql   = ($expiry == '' || $expiry == null) ? 'NULL' : "'".mysqli_real_escape_string($conn, $expiry)."'";
        $name_sql     = mysqli_real_escape_string($conn, $name);
        $location_sql = ($location == '') ? 'NULL' : "'".mysqli_real_escape_string($conn, $location)."'";

        $sql = "INSERT INTO medicines (barcode, name, category, price, cost_price, quantity, expiry_date, location) 
                VALUES ($barcode_sql, '$name_sql', $category_sql, $price, $cost_price, $quantity, $expiry_sql, $location_sql)";
        if (mysqli_query($conn, $sql)) {
            $medicine_id = mysqli_insert_id($conn);

            // حفظ البدائل
            foreach ($alternatives as $alt_id) {
                $alt_id = intval($alt_id);
                if ($alt_id > 0) {
                    mysqli_query($conn, "INSERT IGNORE INTO medicine_alternatives (medicine_id, alternative_id) VALUES ($medicine_id, $alt_id)");
                }
            }

            // إضافة شراء/مورد عند وجود كمية
            if ($quantity > 0) {
                $supplier_sql    = $supplier ? "'".mysqli_real_escape_string($conn, $supplier)."'" : "NULL";
                $paid_amount_sql = ($paid_amount > 0) ? $paid_amount : "NULL";
                $notes_sql       = $notes ? "'".mysqli_real_escape_string($conn, $notes)."'" : "NULL";
                $ins = "INSERT INTO purchases (medicine_id, quantity, cost_price, supplier, paid_amount, notes) 
                        VALUES ($medicine_id, $quantity, $cost_price, $supplier_sql, $paid_amount_sql, $notes_sql)";
                mysqli_query($conn, $ins);
            }
            $success = "تمت إضافة الدواء بنجاح!";
        } else {
            $error = "حدث خطأ أثناء إضافة الدواء!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة دواء جديد</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {background: #f7fbfd; font-family: 'Cairo', Arial, sans-serif;}
        .container {
            max-width: 460px; margin: 60px auto; background: #fff;
            border-radius: 20px; box-shadow: 0 8px 32px #dbe7f3b8; padding: 38px 28px 20px 28px;
        }
        h2 {text-align: center; color: #1976d2;}
        .msg {text-align: center; font-size: 1.1rem;}
        .msg.error {color: #d32f2f;}
        .msg.success {color: #43a047;}
        form {margin-top: 22px;}
        .input-group {margin-bottom: 17px;}
        label {display: block; margin-bottom: 7px; font-weight: bold;}
        input[type="text"], input[type="number"], input[type="date"], textarea, select {
            width: 100%; padding: 11px; border-radius: 10px;
            border: 1px solid #c4d3f6; background: #f6f9ff;
            font-size: 1rem;
        }
        textarea {min-height: 44px;}
        select[multiple] {height: 90px;}
        .barcode-row {display: flex; align-items: center; gap: 7px;}
        .barcode-row input[type="text"] {flex: 1;}
        .scan-btn {
            background: #ffd500; color: #444; border: none; border-radius: 8px;
            padding: 9px 14px; cursor: pointer; font-weight: bold; transition: background 0.2s;
        }
        .scan-btn:hover {background: #ffe665;}
        .btn {
            width: 100%; background: #1976d2; color: #fff;
            padding: 13px; border: none; border-radius: 12px;
            font-size: 1.1rem; font-weight: bold; cursor: pointer; margin-top: 8px;
        }
        .back-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(90deg,#eaf1fb 70%,#f7fbfd 100%);
            color: #1976d2;
            border: 1.5px solid #b6cced;
            border-radius: 9px;
            font-weight: bold;
            font-size: 1.09rem;
            padding: 8px 25px 8px 16px;
            text-decoration: none;
            margin: 17px auto 0 auto;
            width: 120px;
            box-shadow: 0 2px 8px #e3eefd57;
            transition: background .18s,box-shadow .18s, color .13s;
            cursor: pointer;
        }
        .back-btn svg {
            margin-left: 8px; margin-right: -3px;
            transition: transform .14s;
        }
        .back-btn:hover {
            background: linear-gradient(90deg,#d9e7fa 80%,#f2faff 100%);
            color: #1253a1;
            box-shadow: 0 6px 28px #1976d223;
            border-color: #1976d2;
            text-decoration: none;
        }
        .back-btn:hover svg {
            transform: translateX(-4px);
            stroke: #1253a1;
        }
        #reader {
            width: 100%; margin: 0 auto 18px auto; border-radius: 14px;
            overflow: hidden; box-shadow: 0 3px 24px #cde9f366; display: none;
        }
        .hide {display: none;}
        .total-box {
            background: #eaf1fb;
            color: #1976d2;
            font-weight: bold;
            border-radius: 8px;
            padding: 11px 10px;
            text-align: center;
            font-size: 1.12rem;
            margin-bottom: 13px;
            margin-top: -7px;
            letter-spacing: 1px;
        }
        small {color:#888;}
    </style>
</head>
<body>
    <div class="container">
        <a href="medicines.php" class="back-btn">
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                <path d="M13 17l-5-5 5-5" stroke="#1976d2" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            رجوع
        </a>
        <h2>إضافة دواء جديد</h2>
        <?php if ($error): ?>
            <div class="msg error"><?= htmlspecialchars($error) ?></div>
        <?php elseif ($success): ?>
            <div class="msg success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>
        <form method="POST" autocomplete="off">
            <div class="input-group">
                <label>الباركود</label>
                <div class="barcode-row">
                    <input type="text" name="barcode" id="barcode-input" maxlength="50" placeholder="اكتب أو امسح باركود">
                    <button type="button" class="scan-btn" id="scan-btn">تشغيل الكاميرا</button>
                </div>
                <div id="reader"></div>
            </div>
            <div class="input-group">
                <label>اسم الدواء</label>
                <input type="text" name="name" required autocomplete="off" placeholder="اسم الدواء">
            </div>
            <div class="input-group">
                <label>التصنيف</label>
                <input type="text" name="category" placeholder="مثلاً: مسكنات">
            </div>
            <div class="input-group">
                <label>سعر البيع</label>
                <input type="number" step="0.01" name="price" required placeholder="سعر البيع">
            </div>
            <div class="input-group">
                <label>سعر الشراء</label>
                <input type="number" step="0.01" name="cost_price" id="cost_price" required placeholder="سعر الشراء">
            </div>
            <div class="input-group">
                <label>الكمية</label>
                <input type="number" name="quantity" id="quantity" min="0" required placeholder="الكمية">
            </div>
            <div id="totalBox" class="total-box">
                إجمالي الفاتورة: <span id="totalValue">0</span> د.ع
            </div>
            <div class="input-group">
                <label>اسم المذخر (اسم المورد)</label>
                <input type="text" name="supplier" placeholder="اسم المذخر أو المورد">
            </div>
            <div class="input-group">
                <label>المبلغ المدفوع</label>
                <input type="number" name="paid_amount" step="0.01" placeholder="المبلغ المدفوع من الفاتورة">
            </div>
            <div class="input-group">
                <label>ملاحظات</label>
                <textarea name="notes" placeholder="ملاحظات أو وصف الفاتورة"></textarea>
            </div>
            <div class="input-group">
                <label>تاريخ الانتهاء</label>
                <input type="date" name="expiry_date">
            </div>
            <div class="input-group">
                <label>موقع الدواء</label>
                <select name="location" required>
                    <option value="">اختر الرف</option>
                    <?php for($i=1;$i<=40;$i++): ?>
                        <option value="الرف <?=$i?>">الرف <?=$i?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="input-group">
                <label>الأدوية البديلة (اختر إن وجدت):</label>
                <select name="alternatives[]" multiple>
                    <?php foreach($medicines_alt as $med): ?>
                        <option value="<?= $med['id'] ?>"><?= htmlspecialchars($med['name']) ?></option>
                    <?php endforeach; ?>
                </select>
                <small>اضغط مع زر Ctrl (أو Cmd للماك) لتحديد أكثر من بديل</small>
            </div>
            <button type="submit" class="btn">إضافة الدواء</button>
        </form>
    </div>
    <script>
        // إجمالي الفاتورة تلقائي
        function updateTotal() {
            let cost = parseFloat(document.getElementById('cost_price').value) || 0;
            let qty = parseInt(document.getElementById('quantity').value) || 0;
            let total = cost * qty;
            document.getElementById('totalValue').textContent = total.toLocaleString();
        }
        document.getElementById('cost_price').addEventListener('input', updateTotal);
        document.getElementById('quantity').addEventListener('input', updateTotal);

        // كاميرا الباركود
        const scanBtn = document.getElementById('scan-btn');
        const readerDiv = document.getElementById('reader');
        let scannerOn = false;
        let html5QrCode;
        scanBtn.onclick = function () {
            if (!scannerOn) {
                readerDiv.style.display = 'block';
                scanBtn.textContent = 'إيقاف الكاميرا';
                scannerOn = true;
                html5QrCode = new Html5Qrcode("reader");
                html5QrCode.start(
                    { facingMode: "environment" },
                    { fps: 10, qrbox: { width: 250, height: 80 } },
                    barcode => {
                        document.getElementById('barcode-input').value = barcode;
                        html5QrCode.stop().then(() => {
                            readerDiv.style.display = 'none';
                            scanBtn.textContent = 'تشغيل الكاميرا';
                            scannerOn = false;
                        });
                    },
                    errorMessage => {}
                );
            } else {
                html5QrCode.stop().then(() => {
                    readerDiv.style.display = 'none';
                    scanBtn.textContent = 'تشغيل الكاميرا';
                    scannerOn = false;
                });
            }
        }
        // عند التحميل حساب الإجمالي في حال وجود قيمة افتراضية
        updateTotal();
    </script>
</body>
</html>
