<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// يمكنك تغيير الحد الأدنى للكمية هنا
$low_stock_limit = 10;

// اليوم الحالي
$today = date('Y-m-d');
// بعد شهر
$next_month = date('Y-m-d', strtotime('+30 days'));

// الأدوية منخفضة الكمية
$q1 = "SELECT * FROM medicines WHERE quantity <= $low_stock_limit ORDER BY quantity ASC";
$res_low = mysqli_query($conn, $q1);

// الأدوية قرب انتهاء الصلاحية (تاريخ الانتهاء خلال شهر)
$q2 = "SELECT * FROM medicines WHERE expiry_date IS NOT NULL AND expiry_date != '' AND expiry_date > '$today' AND expiry_date <= '$next_month' ORDER BY expiry_date ASC";
$res_exp = mysqli_query($conn, $q2);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تنبيهات الأدوية</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {background: #f7fbfd; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 900px; margin: 30px auto;}
        h2 {color: #d32f2f; text-align: center;}
        h3 {color: #1976d2;}
        table {width: 100%; border-collapse: collapse; background: #fff; margin-bottom: 34px;}
        th, td {padding: 10px; text-align: center; border-bottom: 1px solid #e3e3e3;}
        th {background: #eaf1fb;}
        .low {color: #c62828; font-weight: bold;}
        .exp {color: #ff9100;}
    </style>
</head>
<body>
<div class="container">
    <h2>تنبيهات الأدوية</h2>

    <!-- جدول الأدوية منخفضة الكمية -->
    <h3>الأدوية منخفضة الكمية (≤ <?= $low_stock_limit ?>)</h3>
    <table>
        <tr>
            <th>اسم الدواء</th>
            <th>الكمية المتوفرة</th>
            <th>باركود</th>
            <th>تاريخ الانتهاء</th>
        </tr>
        <?php if ($res_low && mysqli_num_rows($res_low) > 0): ?>
            <?php while($row = mysqli_fetch_assoc($res_low)): ?>
            <tr>
                <td><?= htmlspecialchars($row['name']) ?></td>
                <td class="low"><?= $row['quantity'] ?></td>
                <td><?= htmlspecialchars($row['barcode']) ?></td>
                <td><?= $row['expiry_date'] ? htmlspecialchars($row['expiry_date']) : '-' ?></td>
            </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr><td colspan="4" style="color:#888;">لا يوجد أدوية منخفضة الكمية حاليًا.</td></tr>
        <?php endif; ?>
    </table>

    <!-- جدول الأدوية قرب انتهاء الصلاحية -->
    <h3>الأدوية التي ستنتهي خلال شهر</h3>
    <table>
        <tr>
            <th>اسم الدواء</th>
            <th>الكمية المتوفرة</th>
            <th>باركود</th>
            <th>تاريخ الانتهاء</th>
            <th>عدد الأيام المتبقية</th>
        </tr>
        <?php if ($res_exp && mysqli_num_rows($res_exp) > 0): ?>
            <?php while($row = mysqli_fetch_assoc($res_exp)):
                $days_left = (strtotime($row['expiry_date']) - strtotime($today)) / 86400;
            ?>
            <tr>
                <td><?= htmlspecialchars($row['name']) ?></td>
                <td><?= $row['quantity'] ?></td>
                <td><?= htmlspecialchars($row['barcode']) ?></td>
                <td class="exp"><?= htmlspecialchars($row['expiry_date']) ?></td>
                <td><?= round($days_left) ?> يوم</td>
            </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr><td colspan="5" style="color:#888;">لا توجد أدوية على وشك الانتهاء خلال شهر.</td></tr>
        <?php endif; ?>
    </table>
</div>
</body>
</html>
