<?php
session_start();
if (!isset($_SESSION['user_id'])) exit;
include('config.php');

// استقبال الفلاتر
$from = isset($_GET['from']) ? $_GET['from'] : date('Y-m-01');
$to   = isset($_GET['to'])   ? $_GET['to']   : date('Y-m-d');
$product_id = isset($_GET['product_id']) && $_GET['product_id'] != '' ? intval($_GET['product_id']) : '';

$filter_sql = "";
if ($product_id) $filter_sql = "WHERE m.id = $product_id";

header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=pharmacy_report_" . date("Ymd_His") . ".xls");

echo "اسم المنتج\tالكمية المدخلة\tالكمية المباعة\tسعر البيع\tسعر الشراء\tإجمالي الربح\tتاريخ آخر فاتورة بيع\n";

$products_query = "
SELECT 
    m.id,
    m.name,
    m.price,
    m.cost_price, 
    IFNULL(SUM(pu.quantity), 0) AS qty_in,
    IFNULL(SUM(si.quantity), 0) AS qty_sold,
    IFNULL(SUM(si.quantity) * (m.price - m.cost_price), 0) as profit,
    MAX(s.sale_date) as last_sale_date
FROM medicines m
LEFT JOIN purchases pu ON pu.medicine_id = m.id
LEFT JOIN sales_items si ON si.medicine_id = m.id
LEFT JOIN sales s ON s.id = si.sale_id AND s.sale_date BETWEEN '$from 00:00:00' AND '$to 23:59:59'
$filter_sql
GROUP BY m.id, m.name, m.price, m.cost_price
ORDER BY profit DESC
";
$res_products = mysqli_query($conn, $products_query);

if ($res_products && mysqli_num_rows($res_products) > 0) {
    while($row = mysqli_fetch_assoc($res_products)) {
        $date = $row['last_sale_date'] ? date('Y-m-d', strtotime($row['last_sale_date'])) : '-';
        echo "{$row['name']}\t{$row['qty_in']}\t{$row['qty_sold']}\t{$row['price']}\t{$row['cost_price']}\t" . number_format($row['profit']) . "\t{$date}\n";
    }
}
exit;
?>
