<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// معالجة تسديد جزء/كامل من الدين
if (isset($_POST['pay_id']) && isset($_POST['pay_amount'])) {
    $pay_id = intval($_POST['pay_id']);
    $pay_amount = floatval($_POST['pay_amount']);
    $note = isset($_POST['pay_note']) ? mysqli_real_escape_string($conn, trim($_POST['pay_note'])) : '';
    $r = mysqli_query($conn, "SELECT paid, total FROM sales WHERE id=$pay_id");
    if ($row = mysqli_fetch_assoc($r)) {
        $new_paid = $row['paid'] + $pay_amount;
        if ($new_paid > $row['total']) $new_paid = $row['total'];
        mysqli_query($conn, "UPDATE sales SET paid=$new_paid, note='$note' WHERE id=$pay_id");
    }
    header("Location: {$_SERVER['PHP_SELF']}");
    exit;
}

// معالجة حذف الفاتورة
if (isset($_POST['delete_id'])) {
    $del_id = intval($_POST['delete_id']);
    mysqli_query($conn, "DELETE FROM sales_items WHERE sale_id=$del_id");
    mysqli_query($conn, "DELETE FROM sales WHERE id=$del_id");
    header("Location: {$_SERVER['PHP_SELF']}");
    exit;
}

// جلب الديون كلها
$sql = "SELECT * FROM sales WHERE payment_type='debt' AND total > paid ORDER BY sale_date DESC";
$res = mysqli_query($conn, $sql);

$rows = [];
$names = [];
if ($res && mysqli_num_rows($res) > 0) {
    while($row = mysqli_fetch_assoc($res)) {
        $row['remain'] = $row['total'] - $row['paid'];
        $rows[] = $row;
        if (!in_array($row['customer_name'], $names)) {
            $names[] = $row['customer_name'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>العملاء المتدينين</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600;900&display=swap" rel="stylesheet">
    <style>
        body {background: #f7fbfd; font-family: 'Cairo', Arial, sans-serif; margin:0;}
        .container {max-width: 1100px; margin: 40px auto 25px auto; background: #fff; border-radius: 28px; box-shadow: 0 6px 34px #d4e4fc5b; padding: 32px 14px 24px 14px;}
        .title {color: #1976d2; font-size: 2.1rem; font-weight: 900; margin-bottom: 20px; text-align: center; letter-spacing: 1px;}
        .search-box {display: flex; gap: 10px; justify-content: center; margin: 15px 0 18px 0; flex-wrap: wrap;}
        .search-box input[type="text"], .search-box select {
            padding: 10px 13px; border-radius: 10px; border: 1.3px solid #b3c6e8; font-size: 1.08rem; background: #f5fafd; min-width: 170px;
        }
        .search-box button {padding: 8px 18px; background: linear-gradient(90deg, #d0eaff 80%, #e5f8ff 100%); color: #1976d2; border-radius: 8px; border: 1px solid #96bbea; font-weight: bold; font-size: 1.06rem; cursor: pointer; transition: background .14s;}
        .search-box button:hover {background: linear-gradient(90deg, #a3d3fa 80%, #d0f2fc 100%);}
        table {width: 100%; border-collapse: collapse; background: #fff; direction: rtl; border-radius: 14px; overflow: hidden; margin-top: 8px;}
        th, td {padding: 11px 8px; text-align: center;}
        th {background: #eaf1fb; color: #1976d2; font-size: 1.07rem;}
        tr {transition: background .16s;}
        tr:hover {background: #e7f3fc85;}
        td {font-size: 1.05rem; color: #212f4b;}
        .remain {font-weight: bold; color: #c41d1d;}
        .paid {color: #39b54a; font-weight: bold;}
        .total {color: #1976d2; font-weight: bold;}
        .note {color: #9d27b0; font-size: 1em;}
        .empty {color: #888; text-align: center; padding: 30px; font-size: 1.12em;}
        .footer-total td {background: #f6fcff; font-size: 1.12em; font-weight: bold; color: #085e98; border-top: 2px solid #1976d2;}
        .action-btns {display: flex; gap: 7px; justify-content: center;}
        .btn-edit, .btn-del {
            border: none; outline: none;
            padding: 6px 13px; font-size: 1em; border-radius: 8px; font-weight: bold; cursor: pointer;
            transition: background .13s, box-shadow .14s, color .13s;
            display: inline-flex; align-items: center; gap: 4px;
        }
        .btn-edit {background:linear-gradient(90deg,#d9f2ea 80%,#c9f5f9 100%); color: #039b79; border: 1px solid #61cbc9;}
        .btn-edit:hover {background:linear-gradient(90deg,#aafae2 80%,#7cdce8 100%); color:#025c4c;}
        .btn-del {background:linear-gradient(90deg,#ffebee 80%,#fff3f7 100%); color: #d32f2f; border: 1px solid #fdc6c6;}
        .btn-del:hover {background:linear-gradient(90deg,#ffd1d9 80%,#ffe6ec 100%); color: #900707;}
        .modal {display:none; position:fixed; top:0; left:0; right:0; bottom:0; background:#19274279; z-index:9999; align-items:center; justify-content:center;}
        .modal.active {display:flex;}
        .modal-content {
            background: #fff; border-radius: 15px; min-width: 320px; max-width:97vw;
            box-shadow: 0 7px 36px #9cc8ff67; padding: 25px 17px 18px 17px;
            display:flex; flex-direction:column; align-items:center;
            animation: fadeIn .33s;
        }
        @keyframes fadeIn { from{opacity:0;} to{opacity:1;} }
        .modal-content label {font-weight:bold; color:#1976d2;}
        .modal-content input[type="number"] {width:94%; padding:7px 10px; border-radius:8px; border:1px solid #b7d9f5; margin:7px 0;}
        .modal-content textarea {width:94%; border-radius:8px; border:1px solid #b7d9f5; margin:7px 0;}
        .modal-content .btn-save {background:linear-gradient(90deg,#d0f5d9 80%,#b4f2ef 100%); color:#02945b; border:1px solid #66d3b1;}
        .modal-content .btn-save:hover {background:linear-gradient(90deg,#82ffd9 80%,#71e7e3 100%);}
        .modal-content .btn-cancel {background:#eee; color:#444; border:1px solid #bbb;}
        .modal-content .btn-cancel:hover {background:#f7e7e7;}
        .modal-content .msg {margin:8px 0 0 0;font-size:.98em;}
        @media(max-width:750px){.container{padding:6px;} .title{font-size:1.3rem;} th,td{font-size:.97rem;padding:7px 2px;} .footer-total td{font-size:.97em;}}
    </style>
</head>
<body>
    <div class="container">
        <div class="title">العملاء المتدينين (ديون الزبائن)</div>
        <div class="search-box">
            <input type="text" id="liveSearch" placeholder="فلترة فورية باسم الزبون..." autocomplete="off" oninput="filterDebtors()">
            <select id="customerFilter" onchange="filterByCustomer()">
                <option value="all">عرض الجميع</option>
                <?php foreach ($names as $cname): ?>
                    <option value="<?= htmlspecialchars($cname) ?>"><?= htmlspecialchars($cname) ?></option>
                <?php endforeach; ?>
            </select>
            <button onclick="resetFilters()">مسح الفلاتر</button>
        </div>
        <table id="debtorsTable">
            <tr>
                <th>اسم الزبون</th>
                <th>رقم الفاتورة</th>
                <th>تاريخ الفاتورة</th>
                <th>إجمالي الفاتورة</th>
                <th>المدفوع</th>
                <th>المتبقي</th>
                <th>ملاحظة</th>
                <th>إجراءات</th>
            </tr>
            <?php
            $total_sum = $paid_sum = $remain_sum = 0;
            if (count($rows) > 0):
                foreach($rows as $row):
                    $total_sum += $row['total'];
                    $paid_sum  += $row['paid'];
                    $remain_sum += $row['remain'];
            ?>
                <tr data-customer="<?= htmlspecialchars($row['customer_name']) ?>">
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                    <td><?= htmlspecialchars($row['id']) ?></td>
                    <td><?= htmlspecialchars($row['sale_date']) ?></td>
                    <td class="total"><?= number_format($row['total'], 2) ?></td>
                    <td class="paid"><?= number_format($row['paid'], 2) ?></td>
                    <td class="remain"><?= number_format($row['remain'], 2) ?></td>
                    <td class="note"><?= $row['note'] ? htmlspecialchars($row['note']) : '--' ?></td>
                    <td>
                        <div class="action-btns">
                            <button class="btn-edit" onclick="openEditModal(<?= $row['id'] ?>,<?= $row['remain'] ?>,<?= $row['total'] ?>,<?= $row['paid'] ?>,'<?= htmlspecialchars(addslashes($row['customer_name'])) ?>')">
                                <svg width="15" height="15" viewBox="0 0 20 20"><path fill="#039b79" d="M16.3 3.7a1 1 0 0 0-1.4 0l-8.9 8.9c-.1.1-.2.3-.3.4l-1 4.3a.99.99 0 0 0 1.2 1.2l4.3-1c.2-.1.3-.1.4-.3l8.9-8.9a1 1 0 0 0 0-1.4l-2-2zm-8.3 10.6l-.7 2.8 2.8-.7 8.1-8.1-2.1-2.1-8.1 8.1z"/></svg>
                                تسديد
                            </button>
                            <form method="post" style="display:inline" onsubmit="return confirm('هل أنت متأكد من حذف الفاتورة بالكامل؟');">
                                <input type="hidden" name="delete_id" value="<?= $row['id'] ?>">
                                <button type="submit" class="btn-del">
                                    <svg width="15" height="15" viewBox="0 0 20 20"><rect x="5" y="7" width="10" height="8" rx="2" fill="none" stroke="#d32f2f" stroke-width="1"/><path d="M7 7V5a3 3 0 0 1 6 0v2" stroke="#d32f2f" stroke-width="1"/></svg>
                                    حذف
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
                <tr class="footer-total" id="footerTotal">
                    <td colspan="3">المجموع الكلي</td>
                    <td id="footerTotalVal"><?= number_format($total_sum, 2) ?></td>
                    <td id="footerPaidVal"><?= number_format($paid_sum, 2) ?></td>
                    <td id="footerRemainVal"><?= number_format($remain_sum, 2) ?></td>
                    <td colspan="2"></td>
                </tr>
            <?php else: ?>
            <tr><td colspan="8" class="empty">لا يوجد أي زبون متدين حالياً.</td></tr>
            <?php endif; ?>
        </table>
    </div>
    <!-- مودال التسديد -->
    <div class="modal" id="editModal">
        <div class="modal-content">
            <form method="post" id="payForm" autocomplete="off" onsubmit="return checkPayAmount()">
                <input type="hidden" name="pay_id" id="modal_pay_id">
                <div style="margin-bottom:6px;font-weight:bold;font-size:1.09em;">
                    تسديد دين للفاتورة رقم <span id="modal_sale_id" style="color:#1976d2;"></span>
                </div>
                <label>اسم الزبون:</label>
                <div id="modal_cust_name" style="margin-bottom:8px;color:#1976d2;font-weight:900;"></div>
                <label>المتبقي حالياً:</label>
                <div id="modal_remain" style="color:#c41d1d;font-weight:bold;margin-bottom:7px;"></div>
                <label>المبلغ المراد تسديده</label>
                <input type="number" step="any" name="pay_amount" id="modal_pay_amount" min="0" required>
                <div class="msg" id="modal_error" style="color:#c41d1d;display:none"></div>
                <label>ملاحظة (اختياري):</label>
                <textarea name="pay_note" rows="2" placeholder="ملاحظات (مثلاً تم التسديد جزئي أو دفع كامل)"></textarea>
                <div style="margin-top:13px;display:flex;gap:9px;">
                    <button type="submit" class="btn-save">تسديد</button>
                    <button type="button" class="btn-cancel" onclick="closeEditModal()">إلغاء</button>
                </div>
            </form>
        </div>
    </div>
    <script>
    // فلترة فورية حسب الاسم النصي
    function filterDebtors() {
        var input = document.getElementById("liveSearch").value.trim().toLowerCase();
        var select = document.getElementById("customerFilter").value;
        var trs = document.querySelectorAll('#debtorsTable tr[data-customer]');
        let total = 0, paid = 0, remain = 0, showCount = 0;
        trs.forEach(function(tr) {
            var name = tr.getAttribute('data-customer').toLowerCase();
            var show = true;
            if (input && name.indexOf(input) === -1) show = false;
            if (select != "all" && name !== select.toLowerCase()) show = false;
            tr.style.display = show ? "" : "none";
            if (show) {
                total += parseFloat(tr.children[3].innerText.replace(/,/g,'')) || 0;
                paid  += parseFloat(tr.children[4].innerText.replace(/,/g,'')) || 0;
                remain+= parseFloat(tr.children[5].innerText.replace(/,/g,'')) || 0;
                showCount++;
            }
        });
        updateFooter(showCount, total, paid, remain);
    }

    // فلترة بالقائمة المنسدلة
    function filterByCustomer() {
        filterDebtors();
    }

    function resetFilters() {
        document.getElementById("liveSearch").value = "";
        document.getElementById("customerFilter").value = "all";
        filterDebtors();
    }

    // تحديث المجموعات السفلية
    function updateFooter(showCount, total, paid, remain) {
        var footer = document.getElementById("footerTotal");
        if (!footer) return;
        footer.style.display = showCount > 0 ? '' : 'none';
        document.getElementById("footerTotalVal").innerText = total.toLocaleString(undefined, {minimumFractionDigits:2,maximumFractionDigits:2});
        document.getElementById("footerPaidVal").innerText  = paid.toLocaleString(undefined, {minimumFractionDigits:2,maximumFractionDigits:2});
        document.getElementById("footerRemainVal").innerText= remain.toLocaleString(undefined, {minimumFractionDigits:2,maximumFractionDigits:2});
        // إظهار رسالة لا يوجد بيانات إذا لا يوجد أي صف ظاهر
        var emptyRow = document.querySelector(".empty");
        if (emptyRow) emptyRow.style.display = showCount == 0 ? "" : "none";
    }

    // مودال التسديد
    function openEditModal(id, remain, total, paid, cname) {
        document.getElementById('editModal').classList.add('active');
        document.getElementById('modal_pay_id').value = id;
        document.getElementById('modal_sale_id').innerText = id;
        document.getElementById('modal_remain').innerText = remain.toLocaleString(undefined, {minimumFractionDigits:2,maximumFractionDigits:2});
        document.getElementById('modal_pay_amount').value = '';
        document.getElementById('modal_pay_amount').max = remain;
        document.getElementById('modal_pay_amount').focus();
        document.getElementById('modal_cust_name').innerText = cname;
        document.getElementById('modal_error').style.display = 'none';
    }
    function closeEditModal() {
        document.getElementById('editModal').classList.remove('active');
    }
    function checkPayAmount() {
        var remain = parseFloat(document.getElementById('modal_remain').innerText.replace(/,/g,'')) || 0;
        var pay = parseFloat(document.getElementById('modal_pay_amount').value) || 0;
        if (pay <= 0 || pay > remain) {
            document.getElementById('modal_error').innerText = "يجب إدخال مبلغ صحيح بين 1 والمبلغ المتبقي";
            document.getElementById('modal_error').style.display = 'block';
            return false;
        }
        return true;
    }
    // تحديث المجاميع عند تغيير الفلاتر
    document.getElementById("liveSearch").addEventListener('input', filterDebtors);
    document.getElementById("customerFilter").addEventListener('change', filterByCustomer);
    </script>
</body>
</html>
