<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// تهيئة السلة
if (!isset($_SESSION['cart'])) $_SESSION['cart'] = array();

// إضافة صنف للسلة
if (isset($_GET['add'])) {
    $medicine_id = intval($_GET['add']);
    $res = mysqli_query($conn, "SELECT * FROM medicines WHERE id = $medicine_id LIMIT 1");
    if ($res && mysqli_num_rows($res) == 1) {
        $medicine = mysqli_fetch_assoc($res);
        if ($medicine['quantity'] > 0) {
            $found = false;
            foreach ($_SESSION['cart'] as &$item) {
                if ($item['id'] == $medicine_id) {
                    if ($item['quantity'] < $medicine['quantity']) {
                        $item['quantity'] += 1;
                        $item['total'] = $item['quantity'] * $medicine['price'];
                    }
                    $found = true;
                    break;
                }
            }
            unset($item);
            if (!$found) {
                $_SESSION['cart'][] = array(
                    'id' => $medicine['id'],
                    'name' => $medicine['name'],
                    'barcode' => $medicine['barcode'],
                    'category' => $medicine['category'],
                    'price' => $medicine['price'],
                    'quantity' => 1,
                    'available' => $medicine['quantity'],
                    'total' => $medicine['price']
                );
            }
        }
    }
    header('Location: cashier.php' . (isset($_GET['search']) ? '?search='.urlencode($_GET['search']) : ''));
    exit;
}

// حذف صنف من السلة
if (isset($_GET['remove'])) {
    $idx = intval($_GET['remove']);
    if (isset($_SESSION['cart'][$idx])) {
        unset($_SESSION['cart'][$idx]);
        $_SESSION['cart'] = array_values($_SESSION['cart']);
    }
}

// إفراغ السلة
if (isset($_GET['clear'])) {
    $_SESSION['cart'] = array();
}

// معالجة إصدار الفاتورة
$success = '';
$error = '';
$sale_id = 0;
if (isset($_POST['checkout']) && isset($_POST['quantities']) && count($_SESSION['cart']) > 0) {
    foreach ($_POST['quantities'] as $idx => $qty) {
        $qty = intval($qty);
        if (isset($_SESSION['cart'][$idx])) {
            $max_qty = $_SESSION['cart'][$idx]['available'];
            if ($qty > 0 && $qty <= $max_qty) {
                $_SESSION['cart'][$idx]['quantity'] = $qty;
                $_SESSION['cart'][$idx]['total'] = $qty * $_SESSION['cart'][$idx]['price'];
            }
        }
    }
    $user_id = $_SESSION['user_id'];
    $total = 0;
    foreach ($_SESSION['cart'] as $item) {
        $total += $item['total'];
    }

    // الدفع (نقد/دين)
    $payment_type = 'cash';
    if (isset($_POST['payment_type'])) $payment_type = $_POST['payment_type'];
    $customer_name = '';
    $paid_amount = $total;
    $remain_amount = 0;

    if ($payment_type == 'debt') {
        $customer_name = isset($_POST['customer_name']) ? trim($_POST['customer_name']) : '';
        $paid_amount = isset($_POST['paid_amount']) ? floatval($_POST['paid_amount']) : 0;
        $remain_amount = $total - $paid_amount;
        if ($customer_name == '') {
            $error = 'يرجى إدخال اسم الزبون عند البيع بالدين.';
        } elseif ($paid_amount < 0 || $paid_amount > $total) {
            $error = 'المبلغ المدفوع يجب أن يكون بين 0 وقيمة الفاتورة.';
        }
    }

    if ($error == '') {
        $sql_sale = "INSERT INTO sales (user_id, sale_date, total, paid, payment_type, customer_name)
                     VALUES ($user_id, NOW(), $total, $paid_amount, '".mysqli_real_escape_string($conn, $payment_type)."', '".mysqli_real_escape_string($conn, $customer_name)."')";
        if (mysqli_query($conn, $sql_sale)) {
            $sale_id = mysqli_insert_id($conn);
            foreach ($_SESSION['cart'] as $item) {
                $medicine_id = intval($item['id']);
                $quantity = intval($item['quantity']);
                $price = floatval($item['price']);
                $total_item = floatval($item['total']);
                mysqli_query($conn, "INSERT INTO sales_items (sale_id, medicine_id, quantity, price, total) VALUES ($sale_id, $medicine_id, $quantity, $price, $total_item)");
                mysqli_query($conn, "UPDATE medicines SET quantity = quantity - $quantity WHERE id = $medicine_id");
            }
            // إذا كان البيع دين يتم تسجيله في جدول الديون
            if ($payment_type == 'debt') {
                $sql_debt = "INSERT INTO debts (customer_name, sale_id, total, paid, remain, date, status)
                             VALUES ('".mysqli_real_escape_string($conn, $customer_name)."', $sale_id, $total, $paid_amount, $remain_amount, NOW(), 'unpaid')";
                mysqli_query($conn, $sql_debt);
            }
            $_SESSION['cart'] = array();
            $success = "تمت عملية البيع بنجاح! رقم الفاتورة: $sale_id";
        } else {
            $error = "حدث خطأ أثناء إصدار الفاتورة.";
        }
    }
}

// البحث عن دواء
$search = '';
if (isset($_GET['search'])) $search = trim($_GET['search']);
$where = '';
if ($search != '') {
    $search_sql = mysqli_real_escape_string($conn, $search);
    $where = "WHERE name LIKE '%$search_sql%' OR barcode LIKE '%$search_sql%'";
}
$medicines = mysqli_query($conn, "SELECT * FROM medicines $where ORDER BY name ASC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>الكاشير - بيع الأدوية</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {background: #f7fbfd; font-family: 'Cairo', Arial, sans-serif; margin:0;}
        .products {max-width: 1100px; margin: 30px auto 70px auto;}
        .search-box {display: flex; gap: 7px; justify-content: center; margin: 20px auto 30px auto; max-width: 650px; position: relative;}
        .search-box input[type="text"] {flex: 1; padding: 11px; border-radius: 9px; border: 1px solid #b6cced; background: #f3f7fb; font-size: 1.09rem;}
        #search-suggestions {position:absolute;top:44px;left:0;right:0;z-index:99;}
        #reader {width: 100%; margin: 0 auto 18px auto; border-radius: 13px; overflow: hidden; display: none;}
        .products-list {display: flex; flex-wrap: wrap; gap: 18px; justify-content: center;}
        .product-card {background: #fff; border-radius: 17px; box-shadow: 0 4px 22px #e2ecfb60; padding: 25px 15px 17px 15px; width: 230px; transition: box-shadow 0.18s, transform 0.16s; position: relative; display: flex; flex-direction: column; align-items: center; cursor: pointer;}
        .product-card:active, .product-card:hover {box-shadow: 0 8px 34px #a6c6fd73; transform: scale(1.03);}
        .product-icon {width: 52px; height: 52px; margin-bottom: 8px; background: linear-gradient(135deg,#e6f7ff 75%,#d4fbf2 100%); border-radius: 13px; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 14px #b8e3ff10;}
        .product-title {font-size: 1.13rem; color: #1976d2; margin-bottom: 6px; text-align: center; font-weight: bold;}
        .product-info {font-size: 1.01rem; color: #333; margin-bottom: 7px;}
        .product-qty {font-size: .93rem; color: #d32f2f;}
        .add-fab {position: absolute; left: 14px; top: 13px; width: 34px; height: 34px; background: #f6fff8; border-radius: 50%; box-shadow: 0 3px 15px #a4f8b444; display: flex; align-items: center; justify-content: center; border: 1.5px solid #43a047; cursor: pointer; transition: background .16s, box-shadow .16s; z-index: 3;}
        .add-fab svg {display: block;}
        .add-fab:hover {background: #d5ffe6; box-shadow: 0 6px 24px #43a04722;}
        @media (max-width:800px){ .products-list{gap:12px;} .product-card{width:98vw;max-width:340px;} }
        .m-btn {display: inline-flex; align-items: center; gap: 3px; padding: 8px 15px; border: 1.5px solid #b6cced; border-radius: 8px; font-weight: bold; font-size: 1.06rem; text-decoration: none; cursor: pointer; transition: background .13s, box-shadow .15s, color .13s, border .13s; box-shadow: 0 1px 7px #e3eefd1c; margin: 2px 2px 2px 0; min-width: 38px;}
        .m-btn svg {vertical-align: middle;}
        .m-btn.buy   {background:linear-gradient(90deg,#e5f7ff 80%,#f3fbff 100%);color:#0288d1;border-color:#a4e0fa;}
        .m-btn.buy:hover {background:linear-gradient(90deg,#cbefff 80%,#e2f6ff 100%);color:#015378;}
        .m-btn.del   {background:linear-gradient(90deg,#ffebee 80%,#fff3f7 100%);color:#d32f2f;border-color:#fdc6c6;}
        .m-btn.del:hover {background:linear-gradient(90deg,#ffdadf 80%,#ffe6ec 100%);color:#900707;}
        .m-btn.search {background: linear-gradient(90deg,#f3faee 80%,#f7fbfd 100%); color: #43a047; border-color: #a4e0fa;}
        .m-btn.search:hover {background: linear-gradient(90deg,#e3f7e7 80%,#eaf5f2 100%); color: #21892f;}
        .m-btn.barcode {background: linear-gradient(90deg,#fffde4 80%,#fefae2 100%); color: #d4a607; border-color: #ffe066;}
        .m-btn.barcode:hover {background: linear-gradient(90deg,#fff8bc 80%,#fff7b0 100%); color: #a87b05;}
        .return-sales-btn {background: linear-gradient(90deg,#fffbe8 80%,#fff3e0 100%); color: #e65100; border: 1.7px solid #ffe066; border-radius: 8px; font-weight: bold; font-size: 1.02rem; padding: 0 19px; height: 44px; display: flex; align-items: center; gap: 6px; transition: background .16s, color .12s, border .14s; box-shadow: 0 1px 7px #ffe9d01c; cursor: pointer; text-decoration: none;}
        .return-sales-btn:hover {background: linear-gradient(90deg,#ffe6bc 80%,#ffefc7 100%); color: #ad6200; border-color: #ffd500;}
        @media(max-width: 650px){ .m-btn{padding:6px 7px;font-size:.97rem;} .return-sales-btn{font-size:.97rem;height:39px;} }
        #cart-icon {position:fixed;bottom:32px;right:32px;z-index:500;cursor:pointer;background:#1976d2;width:62px;height:62px;display:flex;align-items:center;justify-content:center;border-radius:50%;box-shadow:0 8px 24px #b1d7f36e;}
        #cart-count {position:absolute;top:11px;right:13px;background:#ffd500;color:#222;font-weight:bold;border-radius:50%;font-size:14px;width:25px;height:25px;display:flex;align-items:center;justify-content:center;}
        #cart-sidebar {position:fixed;bottom:0;right:-410px;width:370px;max-width:98vw;height:100%;background:#fff;box-shadow:-8px 0 36px #c3dbf366;z-index:1000;transition:all .32s cubic-bezier(.69,1.47,.48,1);padding:24px 13px 13px 13px;border-radius:18px 0 0 18px;overflow:auto;}
        .cart-table {width: 100%; border-collapse: collapse; background: #fff;}
        th, td {padding: 7px; text-align: center; border-bottom: 1px solid #e3e3e3;}
        th {background: #eaf1fb;}
        .qty-input {width: 55px; padding: 4px; border-radius: 6px; border: 1px solid #c4d3f6; text-align: center;}
        .success {color: #43a047; text-align:center;}
        .error {color: #d32f2f; text-align:center;}
        .pay-type-row {display: flex; gap:18px; margin-bottom:7px;justify-content:center;}
        @media (max-width:800px){ #cart-sidebar{width:100vw;max-width:100vw;} #cart-icon{bottom:17px;right:17px;} }
        .debt-fields {margin:8px 0 12px 0;}
        .debt-fields input {margin-bottom:5px;}
        .debt-fields label {display:block;margin-bottom:3px;color:#1976d2;font-weight:bold;}
        .remain-box {color:#c41d1d;font-weight:bold;}
    </style>
</head>
<body>
    <h1 style="text-align:center;color:#1976d2;margin-top:24px;">الكاشير - بيع الأدوية</h1>
    <?php if ($success != ''): ?>
        <div class="msg success"><?= htmlspecialchars($success) ?></div>
        <?php if ($sale_id): ?>
            <a href="print_invoice.php?sale_id=<?= $sale_id ?>" target="_blank" class="m-btn buy" style="margin:12px auto;display:block;max-width:220px;">
                🖨️ طباعة الفاتورة
            </a>
        <?php endif; ?>
    <?php elseif ($error != ''): ?>
        <div class="msg error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <div class="products">
        <form method="get" class="search-box" autocomplete="off" style="gap:8px;">
            <input type="text" id="search-input" name="search" placeholder="بحث بالاسم أو الباركود" value="<?= htmlspecialchars($search) ?>">
            <div id="search-suggestions"></div>
            <button type="button" class="m-btn barcode" id="scan-btn" title="بحث بالباركود">
                <svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg>
                باركود
            </button>
            <button type="submit" class="m-btn search">
                <svg width="16" height="16" viewBox="0 0 20 20"><circle cx="9" cy="9" r="6" stroke="#43a047" stroke-width="1.7" fill="none"/><path d="M15 15l-3-3" stroke="#43a047" stroke-width="1.7" stroke-linecap="round"/></svg>
                بحث
            </button>
            <a href="sales_return.php" class="return-sales-btn" title="مرتجع المبيعات">
                <svg width="19" height="19" viewBox="0 0 24 24" style="margin-right:2px;"><path fill="#e65100" d="M12.71 17.29a1 1 0 0 1-1.42 1.42l-4-4a1 1 0 0 1 0-1.42l4-4a1 1 0 1 1 1.42 1.42L10.41 13H17a1 1 0 1 1 0 2h-6.59l2.3 2.29z"/></svg>
                مرتجع المبيعات
            </a>
        </form>
        <div id="reader"></div>
        <div class="products-list">
            <?php if ($medicines && mysqli_num_rows($medicines) > 0): ?>
                <?php while($med = mysqli_fetch_assoc($medicines)): ?>
                <div class="product-card" onclick="window.location='?add=<?= $med['id'] ?><?= $search ? '&search='.urlencode($search) : '' ?>'">
                    <div class="add-fab" title="أضف للسلة" onclick="event.stopPropagation();window.location='?add=<?= $med['id'] ?><?= $search ? '&search='.urlencode($search) : '' ?>';">
                        <svg width="22" height="22" viewBox="0 0 22 22"><circle cx="11" cy="11" r="10" fill="#fff"/><path d="M11 7v8M7 11h8" stroke="#43a047" stroke-width="2.3" stroke-linecap="round"/></svg>
                    </div>
                    <div class="product-icon">
                        <svg width="34" height="34" viewBox="0 0 48 48" fill="none">
                            <rect x="9" y="18" width="30" height="12" rx="6" fill="#f5fafd"/>
                            <rect x="17" y="16" width="14" height="16" rx="7" fill="#13c6a3"/>
                            <rect x="24" y="16" width="7" height="16" rx="3.5" fill="#fff"/>
                            <circle cx="24" cy="24" r="5" fill="#fff" opacity=".28"/>
                        </svg>
                    </div>
                    <div class="product-title"><?= htmlspecialchars($med['name']) ?></div>
                    <div class="product-info">باركود: <span><?= htmlspecialchars($med['barcode']) ?></span></div>
                    <div class="product-info">التصنيف: <span><?= htmlspecialchars($med['category']) ?></span></div>
                    <div class="product-info">سعر البيع: <b><?= htmlspecialchars($med['price']) ?></b></div>
                    <div class="product-info">الكمية المتوفرة: <span class="product-qty"><?= htmlspecialchars($med['quantity']) ?></span></div>
                    <?php if(!empty($med['location'])): ?>
                        <div class="product-info" style="color:#1976d2;">
                            موقع الدواء: <b><?= htmlspecialchars($med['location']) ?></b>
                        </div>
                    <?php endif; ?>
                </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div style="text-align:center;width:100%;color:#999;margin:20px 0;">لا توجد أدوية مطابقة.</div>
            <?php endif; ?>
        </div>
    </div>
    <div id="cart-icon">
        <svg width="36" height="36" fill="#fff" viewBox="0 0 24 24"><path d="M7 18c-1.104 0-2 .896-2 2s.896 2 2 2 2-.896 2-2-.896-2-2-2zm10 0c-1.104 0-2 .896-2 2s.896 2 2 2 2-.896 2-2-.896-2-2-2zm2.832-3.554a1.001 1.001 0 0 0 .881-1.47l-2.82-5.084A2.997 2.997 0 0 0 15.381 6H6.21l-.94-2H1v2h2l3.6 7.59-1.35 2.44A1.003 1.003 0 0 0 6 18h12v-2H7.42c-.14 0-.25-.11-.25-.25s.11-.25.25-.25h10.38a1 1 0 0 0 .894-.553zm-2.32-2.446H7.41l1.1-2h7.45l1.1 2z"/></svg>
        <span id="cart-count"><?php echo (isset($_SESSION['cart']) && count($_SESSION['cart']) > 0) ? count($_SESSION['cart']) : 0; ?></span>
    </div>
    <div id="cart-sidebar">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:14px;">
            <h2 style="color:#1976d2;font-size:1.12rem;">سلة البيع</h2>
            <button onclick="closeCart()" style="background:transparent;border:none;font-size:25px;cursor:pointer;color:#1976d2;">&times;</button>
        </div>
        <?php if (isset($_SESSION['cart']) && count($_SESSION['cart']) > 0): ?>
        <form method="POST" id="cart-form" autocomplete="off">
            <table class="cart-table">
                <tr>
                    <th>الدواء</th>
                    <th>السعر</th>
                    <th>الكمية</th>
                    <th>الإجمالي</th>
                    <th>حذف</th>
                </tr>
                <?php foreach ($_SESSION['cart'] as $idx => $item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['name']) ?></td>
                    <td><?= htmlspecialchars($item['price']) ?></td>
                    <td>
                        <input type="number" name="quantities[<?= $idx ?>]" value="<?= $item['quantity'] ?>" min="1" max="<?= $item['available'] ?>" class="qty-input" onchange="updateTotal(<?= $idx ?>)">
                    </td>
                    <td class="item-total" id="item-total-<?= $idx ?>"><?= htmlspecialchars($item['total']) ?></td>
                    <td>
                        <a href="?remove=<?= $idx ?>" class="m-btn del" onclick="return confirm('تأكيد الحذف؟');" title="حذف">
                            <svg width="16" height="16" viewBox="0 0 20 20"><path d="M6 8v6M10 8v6m4-6v6M4 6h12" stroke="#d32f2f" stroke-width="1.2" stroke-linecap="round"/><rect x="5" y="6" width="10" height="10" rx="2" fill="none" stroke="#d32f2f" stroke-width="1"/></svg>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <tr>
                    <th colspan="3">الإجمالي الكلي</th>
                    <th colspan="2" id="cart-total">
                        <?php
                        $total = 0;
                        foreach ($_SESSION['cart'] as $item) $total += $item['total'];
                        echo $total;
                        ?>
                    </th>
                </tr>
            </table>
            <!-- خيارات الدفع -->
            <div class="pay-type-row">
                <label><input type="radio" name="payment_type" value="cash" checked> نقداً</label>
                <label><input type="radio" name="payment_type" value="debt" <?php echo (isset($_POST['payment_type']) && $_POST['payment_type'] == 'debt') ? 'checked' : ''; ?>> دين</label>
            </div>
            <div id="debt-customer-box" class="debt-fields" style="display:<?php echo (isset($_POST['payment_type']) && $_POST['payment_type'] == 'debt') ? 'block' : 'none'; ?>;">
                <label>اسم الزبون</label>
                <input type="text" name="customer_name" id="debt-customer-name" placeholder="اسم الزبون (الدين)" style="width:96%;padding:7px 9px;border-radius:8px;border:1px solid #bbb;" value="<?php echo isset($_POST['customer_name']) ? htmlspecialchars($_POST['customer_name']) : ''; ?>">
                <label>المبلغ المدفوع</label>
                <input type="number" name="paid_amount" id="debt-paid-amount" min="0" step="any" value="<?php echo isset($_POST['paid_amount']) ? htmlspecialchars($_POST['paid_amount']) : '0'; ?>" style="width:96%;padding:7px 9px;border-radius:8px;border:1px solid #bbb;">
                <div style="margin-top:6px;">
                    <span>المبلغ المتبقي:</span>
                    <span id="remain-val" class="remain-box">0</span>
                </div>
            </div>
            <button type="submit" name="checkout" class="m-btn buy" style="width:99%;margin-top:12px;">
                <svg width="18" height="18" viewBox="0 0 20 20"><circle cx="10" cy="10" r="8" stroke="#0288d1" stroke-width="1.5" fill="none"/><path d="M10 6v4m0 0v4m0-4h4m-4 0H6" stroke="#0288d1" stroke-width="1.5" stroke-linecap="round"/></svg>
                إصدار الفاتورة
            </button>
            <a href="?clear=1" class="m-btn del" onclick="return confirm('تأكيد إفراغ السلة؟');" style="width:99%;margin-top:7px;">
                <svg width="16" height="16" viewBox="0 0 20 20"><path d="M6 8v6M10 8v6m4-6v6M4 6h12" stroke="#d32f2f" stroke-width="1.2" stroke-linecap="round"/><rect x="5" y="6" width="10" height="10" rx="2" fill="none" stroke="#d32f2f" stroke-width="1"/></svg>
                إفراغ السلة
            </a>
        </form>
        <?php else: ?>
            <div style="text-align:center; color:#888;">لا توجد أصناف في السلة حالياً.</div>
        <?php endif; ?>
    </div>
    <script>
    // البحث الذكي (autocomplete)
    const searchInput = document.getElementById('search-input');
    const suggestionsBox = document.getElementById('search-suggestions');

    searchInput.addEventListener('input', function() {
        const q = this.value.trim();
        if (q.length === 0) {
            suggestionsBox.innerHTML = '';
            return;
        }
        fetch('medicine_search.php?q=' + encodeURIComponent(q))
            .then(resp => resp.json())
            .then(data => {
                if (data.length === 0) {
                    suggestionsBox.innerHTML = '';
                    return;
                }
                let html = '<div style="position:absolute;z-index:99;background:#fff;border:1px solid #b6cced;width:100%;border-radius:10px;box-shadow:0 5px 18px #dbe7f366;max-height:230px;overflow-y:auto;">';
                data.forEach(med => {
                    html += `<div style="padding:10px;cursor:pointer;font-size:1.06rem;" onclick="selectSuggestion('${med.name.replace(/'/g,"\\'")}', '${med.id}')">${med.name} <span style='color:#aaa;font-size:.93em;'>(${med.barcode})</span></div>`;
                });
                html += '</div>';
                suggestionsBox.innerHTML = html;
            });
    });

    // هنا التعديل: فقط بحث، لا إضافة للسلة تلقائياً
    function selectSuggestion(name, id) {
        searchInput.value = name;
        suggestionsBox.innerHTML = '';
        searchInput.form.submit(); // تظهر كارت الدواء فقط
    }

    searchInput.addEventListener('blur', function() {
        setTimeout(()=>{ suggestionsBox.innerHTML = ''; }, 200);
    });

    // فتح وإغلاق السلة وحساب الإجمالي
    const cartIcon = document.getElementById('cart-icon');
    const cartSidebar = document.getElementById('cart-sidebar');
    cartIcon.onclick = function() {
        cartSidebar.style.right = '0';
        document.body.style.overflow = 'hidden';
    };
    function closeCart(){
        cartSidebar.style.right = '-410px';
        document.body.style.overflow = '';
    }
    document.addEventListener('click', function(e){
        if(cartSidebar.style.right=='0px' && !cartSidebar.contains(e.target) && !cartIcon.contains(e.target)){
            closeCart();
        }
    });

    function updateTotal(idx) {
        <?php foreach ($_SESSION['cart'] as $idx => $item): ?>
        if (idx === <?= $idx ?>) {
            var qtyInput = document.querySelector('input[name="quantities[<?= $idx ?>]"]');
            var price = <?= $item['price'] ?>;
            var qty = parseInt(qtyInput.value) || 1;
            document.getElementById('item-total-<?= $idx ?>').textContent = (qty * price).toFixed(2);
        }
        <?php endforeach; ?>
        var total = 0;
        <?php foreach ($_SESSION['cart'] as $idx => $item): ?>
            var qty = parseInt(document.querySelector('input[name="quantities[<?= $idx ?>]"]').value) || 1;
            total += qty * <?= $item['price'] ?>;
        <?php endforeach; ?>
        document.getElementById('cart-total').textContent = total.toFixed(2);
        calcRemain();
    }

    // خيارات الدفع: إظهار حقول الدين
    document.addEventListener('DOMContentLoaded', function() {
        var radios = document.querySelectorAll('input[name="payment_type"]');
        var debtBox = document.getElementById('debt-customer-box');
        radios.forEach(function(el) {
            el.addEventListener('change', function() {
                if (this.value === 'debt') {
                    debtBox.style.display = 'block';
                    calcRemain();
                } else {
                    debtBox.style.display = 'none';
                    document.getElementById('debt-customer-name').value = '';
                    document.getElementById('debt-paid-amount').value = 0;
                    document.getElementById('remain-val').textContent = '0';
                }
            });
        });
        document.getElementById('debt-paid-amount').addEventListener('input', calcRemain);
        calcRemain();
    });

    function calcRemain() {
        var totalVal = 0;
        var cartTotal = document.getElementById('cart-total');
        if (cartTotal) totalVal = parseFloat(cartTotal.textContent) || 0;
        var paidVal = parseFloat(document.getElementById('debt-paid-amount').value) || 0;
        var remain = totalVal - paidVal;
        document.getElementById('remain-val').textContent = remain.toFixed(2);
    }

    // تشغيل الكاميرا للبحث بالباركود
    const scanBtn = document.getElementById('scan-btn');
    const readerDiv = document.getElementById('reader');
    let scannerOn = false;
    let html5QrCode;
    scanBtn.onclick = function () {
        if (!scannerOn) {
            readerDiv.style.display = 'block';
            scanBtn.textContent = 'إيقاف الكاميرا';
            scannerOn = true;
            html5QrCode = new Html5Qrcode("reader");
            html5QrCode.start(
                { facingMode: "environment" },
                { fps: 10, qrbox: { width: 250, height: 80 } },
                function(barcode) {
                    searchInput.value = barcode;
                    html5QrCode.stop().then(function() {
                        readerDiv.style.display = 'none';
                        scanBtn.innerHTML = '<svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg> باركود';
                        scannerOn = false;
                        searchInput.form.submit();
                    });
                },
                function(errorMessage){}
            );
        } else {
            html5QrCode.stop().then(function() {
                readerDiv.style.display = 'none';
                scanBtn.innerHTML = '<svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg> باركود';
                scannerOn = false;
            });
        }
    }
    </script>
</body>
</html>
