<?php
include('config/constants.php');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>طلبات النادل الحالية</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body { background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif; margin: 0;}
        .container { max-width: 850px; margin: 45px auto 35px; background: #fff; border-radius: 22px; box-shadow: 0 5px 30px #dbe7f380; padding: 34px 18px 26px 18px;}
        h2 { text-align: center; color: #1976d2; font-size: 2.2rem; margin-bottom: 24px; font-weight: 700; letter-spacing: 1px;}
        table { width: 100%; border-collapse: collapse; background: #fff; direction: rtl; font-size: 1.15rem;}
        th, td { padding: 12px 10px; border-bottom: 1.2px solid #ececec; text-align: center;}
        th { background: #16a085; color: #fff; font-size: 1.08rem; letter-spacing: 0.5px;}
        tr:last-child td { border-bottom: none; }
        .btn-done { background: #43a047; color: #fff; border: none; padding: 7px 22px; border-radius: 9px; cursor: pointer; font-size: 1rem; transition: 0.16s;}
        .btn-done:hover { background: #30833b; }
        .status-waiting { color: #ff9800; font-weight: bold;}
        .status-done { color: #388e3c; font-weight: bold;}
        .device-token { font-size: 0.9rem; direction: ltr; color: #888; word-break: break-all;}
        .notify-btn {position:fixed;top:10px;left:10px;z-index:999;padding:8px 18px;font-size:17px;border-radius:10px;background:#ffd600;color:#333;border:none;cursor:pointer;box-shadow:0 2px 10px #ddd;}
        .notify-btn:active {background:#ffe866;}
        @media (max-width:600px) {
            .container { padding: 6px 1px 12px 1px; }
            th, td { padding: 7px 2px; font-size: 0.97rem;}
            h2 { font-size: 1.35rem;}
            .notify-btn { font-size:14px; padding:5px 11px;}
        }
    </style>
</head>
<body>
<!-- زر تفعيل التنبيه -->
<button class="notify-btn" onclick="enableNotify()">🔊 تفعيل التنبيه</button>

<div class="container">
    <h2>طلبات النادل الحالية</h2>
    <div id="waiter-table"></div>
</div>

<!-- مشغل الصوت -->
<audio id="notifySound" src="notify.mp3" preload="auto"></audio>

<script>
let audio = document.getElementById('notifySound');
let audioEnabled = false;
let lastCount = 0;

// دالة تفعيل الصوت بعد أول ضغطة زر
function enableNotify(){
    audio.play();
    audioEnabled = true;
    document.querySelector('.notify-btn').style.display = 'none';
}

// جلب طلبات النادل وعرضها
function fetchWaiterRequests(){
    fetch('fetch_waiter_requests.php')
    .then(res => res.text())
    .then(html => {
        document.getElementById('waiter-table').innerHTML = html;
        let newCount = document.querySelectorAll('#waiter-table tr.data-row').length;
        // شغل الصوت فقط إذا تم التفعيل وبعد أول طلب جديد
        if(newCount > lastCount && lastCount !== 0 && audioEnabled){
            audio.currentTime = 0;
            audio.play();
        }
        lastCount = newCount;
    });
}

// زر "تمت الخدمة" عبر AJAX:
document.addEventListener('click', function(e){
    if(e.target && e.target.classList.contains('btn-done')){
        e.preventDefault();
        let id = e.target.getAttribute('data-id');
        fetch('fetch_waiter_requests.php', {
            method:'POST',
            headers: {'Content-Type':'application/x-www-form-urlencoded'},
            body:'done=1&id=' + encodeURIComponent(id)
        })
        .then(res=>res.text())
        .then(html=>{
            document.getElementById('waiter-table').innerHTML = html;
            // حدث العد من جديد بعد التحديث
            lastCount = document.querySelectorAll('#waiter-table tr.data-row').length;
        });
    }
});

// بدء أول جلب وتحديث كل 5 ثوانٍ
fetchWaiterRequests();
setInterval(fetchWaiterRequests, 5000);
</script>
</body>
</html>
