<?php
include('config/constants.php');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>المطبخ - إدارة الطلبات</title>
<style>
body {
  background: #f3f6fa;
  font-family: 'Tajawal', Arial, sans-serif;
  direction: rtl;
}
.kitchen-header {
  text-align: center;
  margin: 25px 0 10px;
  font-size: 2rem;
  color: #1976d2;
  font-weight: bold;
}
.kitchen-grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(200px,1fr));
  gap: 20px;
  margin: 25px;
}
.kitchen-card {
  border-radius: 18px;
  padding: 20px 14px 18px 14px;
  text-align: center;
  box-shadow: 0 3px 18px #0002;
  cursor: pointer;
  min-height: 110px;
  border: 3px solid #ffd600;
  background: linear-gradient(135deg, #fffde7 60%, #fff 100%);
  transition: 0.18s;
  position: relative;
}
.kitchen-card.completed {
  border-color: #43a047;
  background: linear-gradient(135deg, #e8f5e9 60%, #fff 100%);
}
.kitchen-card .table-num {
  font-size: 30px;
  font-weight: bold;
  color: #222;
  margin-bottom: 8px;
}
.kitchen-card .order-status {
  color: #8e24aa;
  font-weight: bold;
  margin-bottom: 8px;
  font-size: 18px;
  display: block;
}
.kitchen-card.completed .order-status {
  color: #43a047;
}
.kitchen-card .order-list {
  margin-bottom: 12px;
  text-align: right;
  direction: rtl;
}
.kitchen-card .order-list li {
  font-size: 15px;
  margin-bottom: 3px;
  list-style: disc inside;
}
.kitchen-card .done-label {
  background: #43a047;
  color: #fff;
  border-radius: 5px;
  font-size: 15px;
  padding: 3px 13px;
  margin-top: 10px;
  display: inline-block;
  font-weight: bold;
}
.kitchen-card .preparing-label {
  background: #8e24aa;
  color: #fff;
  border-radius: 5px;
  font-size: 15px;
  padding: 3px 13px;
  margin-top: 10px;
  display: inline-block;
  font-weight: bold;
}
.kitchen-card:hover {
  transform: scale(1.03) translateY(-5px);
  box-shadow: 0 10px 28px #1976d240;
}
.kitchen-clear-btn {
  margin: 20px auto 0;
  display: block;
  background: #e53935;
  color: #fff;
  border: none;
  padding: 12px 35px;
  border-radius: 7px;
  font-size: 17px;
  font-weight: bold;
  cursor: pointer;
  transition: 0.17s;
}
.kitchen-clear-btn:hover {
  background: #b71c1c;
}
/* شارة دليفري */
.delivery-label {
  color: #fff;
  background: #e53935;
  border-radius: 6px;
  padding: 3px 10px;
  font-size: 15px;
  margin-right:7px;
  display:inline-block;
}
</style>
</head>
<body>

<div class="kitchen-header">لوحة المطبخ - الطلبات الجارية</div>
<button class="kitchen-clear-btn" onclick="clearOrders()">مسح جميع الطلبات الحالية</button>
<div id="kitchen_container" class="kitchen-grid"></div>

<script>
// تحميل الطاولات الجارية للمطبخ
function loadKitchenOrders() {
  fetch('fetch_kitchen.php')
    .then(res => res.text())
    .then(html => {
      document.getElementById('kitchen_container').innerHTML = html;
    });
}
loadKitchenOrders();
setInterval(loadKitchenOrders, 7000);

// عند الضغط على كارت الطلب (يتم التسليم/الحذف من المطبخ فقط)
function markAsDone(kitchenOrderId) {
  if(confirm('تأكيد تسليم الطلب؟')) {
    fetch('kitchen_actions.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: 'action=done&kitchen_order_id=' + encodeURIComponent(kitchenOrderId)
    })
    .then(res => res.json())
    .then(data => {
      if(data.success) {
        loadKitchenOrders();
      } else {
        alert('حدث خطأ أثناء التحديث! ' + (data.sql_error || data.message));
      }
    });
  }
}

// زر مسح جميع الطلبات (من جدول المطبخ فقط)
function clearOrders() {
  if(confirm('هل أنت متأكد من حذف جميع الطلبات؟')) {
    fetch('kitchen_actions.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: 'action=clear'
    })
    .then(res => res.json())
    .then(data => {
      if(data.success) {
        loadKitchenOrders();
      } else {
        alert('حدث خطأ أثناء الحذف! ' + (data.sql_error || data.message));
      }
    });
  }
}
</script>
</body>
</html>
