<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() == PHP_SESSION_NONE) session_start();
if (!defined('SITEURL'))     define('SITEURL', 'https://mosul.pw/onlinefood-order/');
if (!defined('LOCALHOST'))   define('LOCALHOST', 'premium129');
if (!defined('DB_USERNAME')) define('DB_USERNAME', 'mosuclaz');
if (!defined('DB_PASSWORD')) define('DB_PASSWORD', 'CgQqC9g4msfD');
if (!defined('DB_NAME'))     define('DB_NAME', 'mosuclaz_onlinefoodorder');
$conn = mysqli_connect(LOCALHOST, DB_USERNAME, DB_PASSWORD, DB_NAME);
if (!$conn) die("فشل الاتصال: " . mysqli_connect_error());
mysqli_set_charset($conn, "utf8mb4");

// جلب الفئات
$cats = [];
$res = mysqli_query($conn, "SELECT * FROM tbl_category WHERE active='Yes'");
while ($row = mysqli_fetch_assoc($res)) {
    $cats[] = $row;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>قائمة الطعام</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Cairo', Arial, sans-serif;
            background: #f7f8fa;
            margin: 0;
        }
        /* شاشة الترحيب */
        .welcome-overlay {
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(255, 245, 220, 0.98);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 5000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.7s;
            font-family: 'Cairo', Arial, sans-serif;
        }
        .welcome-overlay.show {
            opacity: 1;
            pointer-events: all;
        }
        .welcome-msg {
            text-align: center;
            background: #fff;
            border-radius: 28px;
            padding: 45px 34px 38px 34px;
            box-shadow: 0 10px 45px #ffe0b5ba;
            font-size: 2.3rem;
            color: #fb8c00;
            font-weight: bold;
            letter-spacing: 1px;
            position: relative;
            animation: welcomePop 1.2s cubic-bezier(.25,1.6,.38,1.09);
        }
        .welcome-msg span {
            display: block;
            font-size: 1.25rem;
            color: #ff9800;
            font-weight: 700;
            margin-top: 16px;
        }
        @keyframes welcomePop {
            0%   {transform: scale(0.6); opacity: 0;}
            70%  {transform: scale(1.09);}
            100% {transform: scale(1); opacity: 1;}
        }
        .foods-container.hide { opacity: 0.1; pointer-events: none;}
        .foods-container {
            max-width: 1150px;
            margin: 28px auto;
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 2px 12px #eee;
            padding: 24px 8px 28px 8px;
            opacity: 1;
            transition: opacity 0.5s;
        }
        h2, .text-center {
            text-align: center;
            color: #1976d2;
            font-size: 2rem;
            margin-bottom: 24px;
            font-weight: 700;
        }
        /* --- بقية التنسيقات (نفس كودك السابق) --- */
        .categories-container {
            position: relative;
            width: 100%;
            margin-bottom: 24px;
        }
        .arrow-right-indicator {
            position: absolute;
            left: 8px;
            top: 50%;
            transform: translateY(-50%);
            z-index: 2;
            pointer-events: none;
            transition: opacity .45s;
            opacity: 1;
            animation: arrow-move 1.3s infinite alternate;
        }
        @keyframes arrow-move {
            0% { left: 8px; }
            100% { left: 22px; }
        }
        .hide-arrow-indicator {
            opacity: 0 !important;
            transition: opacity .45s;
        }
        .categories {
            display: flex;
            gap: 8px;
            overflow-x: auto;
            padding-bottom: 7px;
            padding-right: 0;
            padding-left: 0;
            scrollbar-width: thin;
            position: relative;
            scroll-behavior: smooth;
            -webkit-overflow-scrolling: touch;
            scroll-padding-inline-start: 10px;
            scroll-padding-inline-end: 10px;
            background: transparent;
        }
        .categories::before, .categories::after { display: none !important; }
        .cat-spacer {
            flex: 0 0 12px;
            width: 12px;
            height: 42px;
            background: transparent;
            padding: 0;
            margin: 0;
            display: block;
        }
        @media (max-width: 700px) {
            .cat-spacer { flex-basis: 8px; width: 8px; height: 38px; }
        }
        .cat-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            background: #ececec;
            color: #222;
            padding: 12px 24px;
            border-radius: 28px;
            border: none;
            font-size: 17px;
            cursor: pointer;
            transition: background 0.25s, color 0.25s;
            outline: none;
            min-width: 110px;
            margin-bottom: 2px;
            white-space: nowrap;
        }
        .cat-btn.active, .cat-btn:hover {
            background: #16a085;
            color: #fff;
        }
        .foods {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 18px;
        }
        .food-card {
            background: #fafafa;
            border-radius: 17px;
            box-shadow: 0 2px 10px #eee;
            padding: 14px 7px 12px 7px;
            transition: transform 0.19s, box-shadow 0.18s;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .food-card:hover {
            transform: scale(1.035);
            box-shadow: 0 6px 24px #16a08530;
        }
        .food-img {
            width: 115px;
            height: 115px;
            border-radius: 16px;
            object-fit: cover;
            margin-bottom: 13px;
            box-shadow: 0 1px 6px #bbb;
            background: #f5f5f5;
            border: 1.7px solid #e3e8ef;
        }
        .food-title {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 6px;
            color: #19676d;
        }
        .food-desc {
            color: #686868;
            font-size: 14px;
            margin-bottom: 7px;
            text-align:center;
            min-height: 32px;
        }
        .food-price {
            color: #16a085;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 2px;
        }
        .waiter-btn {
            display:inline-block;
            background: #ffb300;
            color:#fff;
            font-size:21px;
            border: none;
            border-radius: 14px;
            padding: 13px 44px;
            margin: 14px auto 16px auto;
            box-shadow: 0 2px 10px #edc84470;
            cursor:pointer;
            font-family: 'Cairo', sans-serif;
            font-weight: bold;
            transition: 0.18s;
        }
        .waiter-btn:hover {
            background: #fb8c00;
            color: #fff;
        }
        #waiterMsg {
            font-size:17px;
            margin:10px auto 10px auto;
            display:block;
            text-align:center;
        }
        @media (max-width:700px){
            .foods-container { padding: 4px 1.5vw 10px 1.5vw; margin: 6px 0; border-radius: 12px;}
            .foods { gap:7px; }
            .categories{ gap:4px; }
            .categories-container { margin-bottom:12px;}
            .food-card { padding: 7px 2px 9px 2px; }
            .food-img { width: 98vw; max-width: 145px; height: 86px;}
            .food-title { font-size: 17px;}
            .food-desc { font-size: 12.2px; min-height: 19px;}
            .food-price { font-size: 16px;}
            .waiter-btn { font-size:17px; padding: 9px 15vw; border-radius: 11px;}
            .arrow-right-indicator svg { width:26px; height:26px;}
            .cat-spacer { flex-basis: 8px; width: 8px; height: 38px; }
            .cat-btn { min-width: 110px; padding: 12px 24px; font-size: 17px;}
        }
    </style>
</head>
<body>
    <!-- رسالة ترحيب متحركة لمطعم خطار -->
    <div class="welcome-overlay" id="welcomeOverlay">
        <div class="welcome-msg">
            مطعم خطار <br>
            <span>يرحب بكم</span>
        </div>
    </div>

    <div class="foods-container hide" id="foodsMain">
        <h2>قائمة الطعام</h2>

        <!-- زر طلب النادل -->
        <div style="text-align:center;">
            <button id="waiterBtn" class="waiter-btn" onclick="requestWaiter()">طلب النادل</button>
            <span id="waiterMsg"></span>
        </div>

        <!-- شريط التصنيفات مع السهم المتحرك -->
        <div class="categories-container">
            <div id="arrowIndicator" class="arrow-right-indicator">
                <svg width="34" height="34" viewBox="0 0 30 30">
                    <circle cx="15" cy="15" r="15" fill="#16a085" fill-opacity="0.18"/>
                    <polyline points="18,10 12,15 18,20" fill="none" stroke="#16a085" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="categories" id="categories">
                <div class="cat-spacer"></div>
                <button class="cat-btn active" data-id="all">جميع الأطعمة</button>
                <?php foreach($cats as $cat): ?>
                    <button class="cat-btn" data-id="<?= $cat['id']; ?>"><?= htmlspecialchars($cat['title']); ?></button>
                <?php endforeach; ?>
                <div class="cat-spacer"></div>
            </div>
        </div>

        <!-- المنتجات -->
        <div class="foods" id="foods">
            <!-- سيتم تحميل الأطعمة هنا عبر Ajax -->
        </div>
    </div>

    <script>
        // رسالة ترحيبية متحركة نفس أسلوبك
        window.onload = function(){
            var welcome = document.getElementById('welcomeOverlay');
            var main    = document.getElementById('foodsMain');
            welcome.classList.add('show');
            setTimeout(function(){
                welcome.classList.remove('show');
                welcome.style.display = 'none';
                main.classList.remove('hide');
            }, 2500); // (2.5 ثانية)
        };

        // بقية كودك كما هو
        document.addEventListener("DOMContentLoaded", function() {
            loadFoods('all');
            document.querySelectorAll('.cat-btn').forEach(function(btn){
                btn.onclick = function(){
                    document.querySelectorAll('.cat-btn').forEach(x=>x.classList.remove('active'));
                    btn.classList.add('active');
                    loadFoods(btn.getAttribute('data-id'));
                }
            });
            function loadFoods(cat_id){
                document.getElementById('foods').innerHTML = '<div style="text-align:center;width:100%;">جاري التحميل...</div>';
                var xhr = new XMLHttpRequest();
                xhr.open('GET', 'fetch_foods_ajax.php?cat_id=' + cat_id, true);
                xhr.onload = function(){
                    document.getElementById('foods').innerHTML = this.responseText;
                }
                xhr.send();
            }

            // السهم الاحترافي في التصنيفات
            const categories = document.getElementById('categories');
            const arrow = document.getElementById('arrowIndicator');
            if(categories && arrow) {
                let checkScrollable = () => {
                    if(categories.scrollWidth > categories.clientWidth){
                        arrow.style.display = 'block';
                    } else {
                        arrow.style.display = 'none';
                    }
                };
                checkScrollable();
                const hideArrow = () => { arrow.classList.add('hide-arrow-indicator'); }
                categories.addEventListener('scroll', hideArrow, { once: true });
                categories.addEventListener('touchstart', hideArrow, { once: true });
                categories.addEventListener('mousedown', hideArrow, { once: true });
                window.addEventListener('resize', checkScrollable);
            }
        });

        // زر طلب النادل
        if(!localStorage.waiter_token){
            localStorage.waiter_token = 'w_' + Math.random().toString(36).substr(2) + '_' + Date.now();
        }
        window.tableNumber = window.tableNumber || '';
        function requestWaiter(){
            var table_number = window.tableNumber || prompt("أدخل رقم الطاولة:");
            if(!table_number) return;
            document.getElementById('waiterMsg').innerHTML = '...جاري إرسال الطلب';
            document.getElementById('waiterMsg').style.color = '#1976d2';
            var formData = new FormData();
            formData.append('table_number', table_number);
            formData.append('device_token', localStorage.waiter_token);

            fetch('waiter_request.php', {method:'POST', body:formData})
            .then(res=>res.json())
            .then(data=>{
                document.getElementById('waiterMsg').innerHTML = data.message;
                document.getElementById('waiterMsg').style.color = data.success ? 'green':'red';
            }).catch(()=>{
                document.getElementById('waiterMsg').innerHTML = 'حدث خطأ أثناء إرسال الطلب، حاول لاحقاً.';
                document.getElementById('waiterMsg').style.color = 'red';
            });
        }
    </script>
</body>
</html>
