<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h2>🛠️ فحص السيرفر وقاعدة البيانات (debug.php)</h2>";

echo "<hr><b>إعدادات PHP:</b><pre>";
echo "max_input_vars: " . ini_get('max_input_vars') . "\n";
echo "post_max_size: " . ini_get('post_max_size') . "\n";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "\n";
echo "memory_limit: " . ini_get('memory_limit') . "\n";
echo "max_execution_time: " . ini_get('max_execution_time') . "\n";
echo "</pre><hr>";

echo "<b>ملفات تعريف الاتصال:</b><br>";
if (file_exists('config/constants.php')) {
    include('config/constants.php');
    echo "تم تضمين constants.php<br>";
} else {
    echo "constants.php غير موجود<br>";
}

if (isset($conn) && $conn) {
    echo "✅ تم الاتصال بقاعدة البيانات بنجاح.<br>";
} else {
    die("<span style='color:red'>❌ فشل الاتصال بقاعدة البيانات: " . mysqli_connect_error() . "</span><br>");
}

// قائمة الجداول وعدد السجلات
$res = mysqli_query($conn, "SHOW TABLES");
if ($res) {
    echo "<hr><b>جداول قاعدة البيانات:</b><ul>";
    while ($row = mysqli_fetch_array($res)) {
        $tbl = $row[0];
        $count = 0;
        $rcount = mysqli_query($conn, "SELECT COUNT(*) as c FROM `$tbl`");
        if ($rcount && $r = mysqli_fetch_assoc($rcount)) $count = $r['c'];
        echo "<li>$tbl <b>($count صف)</b></li>";
    }
    echo "</ul>";
}

// تجربة استعلام SELECT من جدول tbl_food
echo "<hr><b>اختبار جلب صنف طعام:</b><br>";
$foodRes = mysqli_query($conn, "SELECT * FROM tbl_food LIMIT 1");
if($foodRes && $row = mysqli_fetch_assoc($foodRes)) {
    echo "<pre>"; print_r($row); echo "</pre>";
} else {
    echo "❌ لم يتم العثور على أصناف طعام<br>";
}

// تجربة إدخال اختبار في tbl_order
echo "<hr><b>اختبار إدخال طلب وهمي:</b><br>";
$sql_test = "INSERT INTO tbl_order (food, price, qty, total, order_date, status, customer_name, customer_contact, customer_email, customer_address)
VALUES ('test_debug', 1, 1, 1, NOW(), 'Pending', '0', '', '', '')";
if (mysqli_query($conn, $sql_test)) {
    echo "✅ تمت إضافة طلب وهمي بنجاح<br>";
    mysqli_query($conn, "DELETE FROM tbl_order WHERE food='test_debug' ORDER BY id DESC LIMIT 1");
} else {
    echo "❌ خطأ في الإدخال: " . mysqli_error($conn) . "<br>";
}

// آخر 5 أخطاء من error_log (إذا وجدت)
$logFile = 'error_log';
if (file_exists($logFile)) {
    echo "<hr><b>آخر 5 رسائل من error_log:</b><pre>";
    $lines = file($logFile);
    echo implode("", array_slice($lines, -5));
    echo "</pre>";
} else {
    echo "<hr>لم يتم العثور على error_log<br>";
}

// طباعة SESSION/GET/POST
echo "<hr><b>POST/GET/SESSION:</b><pre>";
print_r($_POST);
print_r($_GET);
if(session_status() == PHP_SESSION_ACTIVE) print_r($_SESSION);
echo "</pre>";

echo "<hr>انتهى الفحص.";
?>
