<?php
include('../config/constants.php');

$param = isset($_GET['table']) ? $_GET['table'] : '';
if (!$param) {
    echo "<div>خطأ في رقم الطاولة أو رقم الطلب.</div>";
    exit;
}

$order_id = null; // تعريف مسبق لضبط المتغير دائماً
$table = null;

if (strpos($param, 'delivery_') === 0) {
    $order_id = intval(substr($param, 9));
    $sql = "SELECT * FROM tbl_order WHERE id='$order_id' AND status NOT IN ('Delivered','Cancelled')";
    $res = mysqli_query($conn, $sql);
} elseif (strpos($param, 'table_') === 0) {
    $table = mysqli_real_escape_string($conn, substr($param, 6));
    $sql = "SELECT * FROM tbl_order WHERE customer_name='$table' AND status NOT IN ('Delivered','Cancelled') ORDER BY id DESC";
    $res = mysqli_query($conn, $sql);
} else {
    echo "<div>طلب غير معروف.</div>";
    exit;
}

if ($res && mysqli_num_rows($res) > 0) {
    $row_first = mysqli_fetch_assoc($res);
    mysqli_data_seek($res, 0); // أرجع المؤشر لأول سجل

    if (!is_null($order_id)) {
        // تفاصيل دليفري منفرد
        echo '<div class="delivery-label">دليفري</div>';
        echo '<div style="margin-bottom:7px;"><b>اسم الزبون:</b> '.htmlspecialchars($row_first['customer_name']).'</div>';
        echo '<div style="margin-bottom:7px;"><b>الهاتف:</b> '.(!empty($row_first['customer_contact']) ? htmlspecialchars($row_first['customer_contact']) : "<span style='color:#aaa'>غير مُدخل</span>").'</div>';
        echo '<div style="margin-bottom:7px;"><b>العنوان:</b> '.(!empty($row_first['customer_address']) ? htmlspecialchars($row_first['customer_address']) : "<span style='color:#aaa'>غير مُدخل</span>").'</div>';
        echo '<h3 style="color:#1976d2;">تفاصيل طلب الدليفري</h3>';
    } else {
        // تفاصيل الطاولة (العادية)
        echo "<h3 style='color:#1976d2;'>تفاصيل طلبات طاولة $table</h3>";
    }

    echo "<table>";
    echo "<tr><th>الوجبة</th><th>الكمية</th><th>السعر</th><th>المجموع</th><th>الحالة</th><th>إجراء</th></tr>";
    $total_sum = 0;
    while ($row = mysqli_fetch_assoc($res)) {
        echo "<tr>";
        echo "<td>".htmlspecialchars($row['food'])."</td>";
        echo "<td id='qty-".$row['id']."'>".$row['qty']."</td>";
        echo "<td>".$row['price']."</td>";
        echo "<td>".$row['total']."</td>";
        echo "<td>".$row['status']."</td>";
        echo "<td>";
        // زر تعديل الكمية
        $param_for_js = !is_null($order_id) ? 'delivery_' . $order_id : 'table_' . $table;
        echo "<button class='act-btn' onclick=\"showEditModal(".$row['id'].", '".$row['qty']."', '".$param_for_js."')\">تعديل</button>";
        // زر حذف
        echo "<button class='act-btn del-btn' onclick=\"if(confirm('تأكيد حذف الطلب؟')) orderAction('".$param_for_js."', 'delete', ".$row['id'].")\">حذف</button>";
        echo "</td>";
        echo "</tr>";

        $total_sum += $row['total'];
    }
    echo "<tr style='background:#e3f4fd;font-weight:bold'>";
    echo "<td colspan='3' style='text-align:left;color:#1976d2'>المجموع الكلي:</td>";
    echo "<td colspan='3' style='color:#1976d2'>".number_format($total_sum,2)."</td>";
    echo "</tr>";

    echo "</table>";

    $param_for_js = !is_null($order_id) ? 'delivery_' . $order_id : 'table_' . $table;
    echo "<div class='actions-row'>";
    echo "<button class='act-btn' onclick=\"orderAction('".$param_for_js."', 'paid')\">اتمام استلام المبلغ (تسديد الكل)</button>";
    echo "<button class='act-btn print-btn' onclick=\"printInvoice('".$param_for_js."')\">طباعة الفاتورة</button>";
    echo "</div>";
} else {
    echo "<div>لا توجد طلبات حالياً لهذه الطاولة أو الطلب.</div>";
}
?>

<style>
.delivery-label {
    color: #fff;
    background: #e53935;
    border-radius: 6px;
    padding: 3px 12px;
    font-size: 16px;
    margin-bottom: 8px;
    display: inline-block;
    font-weight: bold;
    letter-spacing: 1px;
}
</style>
