<?php
session_start();
include 'db.php';

// ✅ تحقق من دخول الإدارة
if (!isset($_SESSION['admin_logged_in']) && !isset($_SESSION['teacher_id'])) {
    // مؤقتاً نسمح بالدخول للجميع
}

// ✅ استقبال فلاتر البحث
$stage   = isset($_GET['stage']) ? trim($_GET['stage']) : '';
$class   = isset($_GET['class']) ? trim($_GET['class']) : '';
$student = isset($_GET['student']) ? trim($_GET['student']) : ''; // ✅ بدل teacher
$subject = isset($_GET['subject']) ? trim($_GET['subject']) : '';

// ✅ إعداد جملة WHERE الديناميكية
$where = "1";
if ($stage != '')   $where .= " AND s.stage='$stage'";
if ($class != '')   $where .= " AND s.class='$class'";
if ($student != '') $where .= " AND s.name LIKE '%$student%'";   // ✅ البحث بالطالب
if ($subject != '') $where .= " AND e.subject LIKE '%$subject%'";

// ✅ فقط التقييمات التي تحتوي على بيانات فعلية
$where .= " AND (e.behavior <> '' OR e.academic_level <> '' OR e.notes <> '')";

// ✅ جلب التقييمات مع المادة والمدرس والطالب
$sql = "
SELECT 
    s.id AS student_id, s.name AS student_name, s.stage, s.class,
    t.name AS teacher_name,
    e.subject,
    e.behavior, e.academic_level, e.notes, e.updated_at
FROM evaluations e
JOIN students s ON e.student_id = s.id
JOIN teachers t ON e.teacher_id = t.id
WHERE $where
ORDER BY s.stage, s.class, s.name ASC
";
$result = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>📊 تقرير تقييم الطلبة</title>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@500;700&display=swap" rel="stylesheet">
<style>
body{font-family:"Cairo",sans-serif;background:#f8f9fa;direction:rtl;margin:0;padding:0;}
.container{width:95%;max-width:1300px;margin:40px auto;background:#fff;padding:25px 30px;border-radius:12px;box-shadow:0 5px 25px rgba(0,0,0,0.1);}
h2{text-align:center;background:#007bff;color:#fff;padding:12px;border-radius:8px;margin-bottom:25px;}
form{margin-bottom:20px;text-align:center;}
select,input[type="text"]{padding:6px 10px;font-size:15px;border-radius:6px;border:1px solid #ccc;margin:0 5px;}
button{padding:8px 15px;border:none;background:#007bff;color:#fff;border-radius:6px;cursor:pointer;}
button:hover{background:#0056b3;}
table{width:100%;border-collapse:collapse;margin-top:15px;}
th,td{border:1px solid #ddd;padding:8px;text-align:center;font-size:14px;}
th{background:#007bff;color:#fff;}
tr:nth-child(even){background:#f9f9f9;}
.note-box{background:#f8f9fa;padding:5px 8px;border-radius:6px;border:1px solid #ddd;white-space:pre-line;text-align:right;}
.level-weak{color:#dc3545;font-weight:bold;}
.level-medium{color:#fd7e14;font-weight:bold;}
.level-good{color:#ffc107;font-weight:bold;}
.level-vgood{color:#20c997;font-weight:bold;}
.level-excellent{color:#198754;font-weight:bold;}
</style>
</head>
<body>
<div class="container">
<h2>📊 تقرير تقييم الطلبة</h2>

<form method="get">
    <select name="stage">
        <option value="">اختر المرحلة</option>
        <option <?php if($stage=='أول متوسط') echo 'selected'; ?>>أول متوسط</option>
        <option <?php if($stage=='الثاني المتوسط') echo 'selected'; ?>>الثاني المتوسط</option>
        <option <?php if($stage=='الثالث المتوسط') echo 'selected'; ?>>الثالث المتوسط</option>
        <option <?php if($stage=='الرابع العلمي') echo 'selected'; ?>>الرابع العلمي</option>
        <option <?php if($stage=='الخامس العلمي') echo 'selected'; ?>>الخامس العلمي</option>
        <option <?php if($stage=='السادس العلمي') echo 'selected'; ?>>السادس العلمي</option>
    </select>

    <select name="class">
        <option value="">الشعبة</option>
        <option <?php if($class=='A') echo 'selected'; ?>>A</option>
        <option <?php if($class=='B') echo 'selected'; ?>>B</option>
        <option <?php if($class=='C') echo 'selected'; ?>>C</option>
        <option <?php if($class=='D') echo 'selected'; ?>>D</option>
        <option <?php if($class=='E') echo 'selected'; ?>>E</option>
    </select>

    <!-- ✅ بحث باسم الطالب -->
    <input type="text" name="student" placeholder="اسم الطالب" value="<?php echo htmlspecialchars($student); ?>">
    <input type="text" name="subject" placeholder="اسم المادة" value="<?php echo htmlspecialchars($subject); ?>">
    <button type="submit">🔍 عرض النتائج</button>
</form>

<table>
<tr>
<th>#</th>
<th>اسم الطالب</th>
<th>المرحلة</th>
<th>الشعبة</th>
<th>المادة</th>
<th>المدرس</th>
<th>تقييم السلوك</th>
<th>ملاحظة السلوك</th>
<th>المستوى الدراسي</th>
<th>ملاحظة المستوى</th>
<th>📅 آخر تحديث</th>
</tr>

<?php
if ($result && mysqli_num_rows($result) > 0) {
    $i = 1;

    function getClass($level) {
        switch($level) {
            case 'ضعيف': return 'level-weak';
            case 'متوسط': return 'level-medium';
            case 'جيد': return 'level-good';
            case 'جيد جداً': return 'level-vgood';
            case 'ممتاز': return 'level-excellent';
            default: return '';
        }
    }

    while($row = mysqli_fetch_assoc($result)) {
        $behavior = isset($row['behavior']) ? $row['behavior'] : '';
        $academic = isset($row['academic_level']) ? $row['academic_level'] : '';
        $subject  = isset($row['subject']) ? $row['subject'] : '—';
        $notes = isset($row['notes']) ? $row['notes'] : '';

        $note_behavior = '';
        $note_academic = '';
        if ($notes != '') {
            if (preg_match('/سلوك:(.*)/u', $notes, $m1)) $note_behavior = trim($m1[1]);
            if (preg_match('/دراسة:(.*)/u', $notes, $m2)) $note_academic = trim($m2[1]);
        }

        if ($behavior == '' && $academic == '' && $note_behavior == '' && $note_academic == '') {
            continue;
        }

        echo "<tr>
        <td>$i</td>
        <td>".htmlspecialchars($row['student_name'])."</td>
        <td>".htmlspecialchars($row['stage'])."</td>
        <td>".htmlspecialchars($row['class'])."</td>
        <td>".htmlspecialchars($subject)."</td>
        <td>".htmlspecialchars($row['teacher_name'])."</td>
        <td class='".getClass($behavior)."'>".htmlspecialchars($behavior)."</td>
        <td><div class='note-box'>".htmlspecialchars($note_behavior)."</div></td>
        <td class='".getClass($academic)."'>".htmlspecialchars($academic)."</td>
        <td><div class='note-box'>".htmlspecialchars($note_academic)."</div></td>
        <td>".($row['updated_at'] ? date('Y-m-d', strtotime($row['updated_at'])) : '-')."</td>
        </tr>";

        $i++;
    }

    if ($i == 1) {
        echo "<tr><td colspan='11' style='color:red;font-weight:bold;'>⚠️ لا توجد تقييمات تحتوي على قيم فعلية.</td></tr>";
    }
} else {
    echo "<tr><td colspan='11' style='color:red;font-weight:bold;'>❌ لا توجد تقييمات مطابقة للبحث.</td></tr>";
}
?>
</table>
</div>

<!-- 🔹 زر عرض سجل السلوك الإداري -->
<div style="text-align:center;margin-top:25px;">
    <button onclick="openBehaviorModal()" 
        style="background:#28a745;color:#fff;padding:10px 20px;border:none;border-radius:8px;font-size:16px;cursor:pointer;">
        📋 عرض سجل السلوك الإداري
    </button>
</div>

<!-- 🔹 نافذة منبثقة -->
<div id="behaviorModal" style="display:none;position:fixed;z-index:999;left:0;top:0;width:100%;height:100%;background:rgba(0,0,0,0.5);">
  <div style="background:#fff;width:90%;max-width:1200px;margin:50px auto;padding:0;border-radius:12px;overflow:hidden;box-shadow:0 0 25px rgba(0,0,0,0.3);">
    <div style="background:#007bff;color:#fff;padding:12px;font-size:18px;text-align:center;position:relative;">
      📋 سجل السلوك الإداري للطلبة
      <span onclick="closeBehaviorModal()" 
            style="position:absolute;left:15px;top:5px;cursor:pointer;font-size:24px;">&times;</span>
    </div>
    <iframe src="https://mosul.pw/system/admin_behavior.php" 
            style="width:100%;height:80vh;border:none;"></iframe>
  </div>
</div>

<script>
function openBehaviorModal(){
  document.getElementById('behaviorModal').style.display='block';
}
function closeBehaviorModal(){
  document.getElementById('behaviorModal').style.display='none';
}
</script>

</body>
</html>
