<?php
session_start();
include 'db.php';

// تأمين
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

date_default_timezone_set('Asia/Baghdad');

// الفلاتر
$sel_type  = isset($_GET['t']) ? trim($_GET['t']) : '';
$sel_month = isset($_GET['m']) ? trim($_GET['m']) : '';

// بناء الشرط
$where = "1";
if ($sel_type !== '') {
    $t = mysqli_real_escape_string($conn, $sel_type);
    $where .= " AND exam_type = '$t' ";
}
if ($sel_month !== '') {
    $m = mysqli_real_escape_string($conn, $sel_month);
    $where .= " AND exam_month = '$m' ";
}

// جلب البيانات
$topics = [];
$q = mysqli_query($conn, "
    SELECT *
    FROM exam_topics
    WHERE $where
    ORDER BY stage ASC, teacher_name ASC, created_at DESC
");
if ($q) {
    while ($row = mysqli_fetch_assoc($q)) {
        $topics[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>المواد الداخلة بالامتحان - للطباعة</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  :root{
    --bg: #edf2f7;          /* خلفية خفيفة */
    --card: #ffffff;        /* كرت أبيض */
    --border: #e2e8f0;      /* حدود خفيفة */
    --title: #1f2937;       /* عنوان غامق */
    --muted: #6b7280;       /* نص ثانوي */
    --accent: #6366f1;      /* أزرق بنفسجي */
    --badge1: #e0f2fe;
    --badge1-border: #7dd3fc;
    --badge2: #ecfdf3;
    --badge2-border: #86efac;
    --badge3: #fef9c3;
    --badge3-border: #fde68a;
    --badge4: #f3e8ff;
    --badge4-border: #d8b4fe;
  }
  body{
    font-family: "Tahoma","DejaVu Sans",sans-serif;
    direction: rtl;
    text-align: right;
    background: var(--bg);
    color:#000;
    font-size: 12px;
    padding: 12px;
  }
  .toolbar{
    text-align:center;
    margin:10px 0 5px;
  }
  .toolbar button{
    padding:6px 14px;
    font-size:12px;
    cursor:pointer;
    border:none;
    background:var(--accent);
    color:#fff;
    border-radius:6px;
  }
  h2{
    text-align:center;
    margin:5px 0 2px;
    color:var(--title);
  }
  .subhead{
    text-align:center;
    font-size:11px;
    margin-bottom:10px;
    color:var(--muted);
  }
  .card{
    background:var(--card);
    border:1px solid var(--border);
    border-radius:10px;
    padding:10px 10px 8px;
    margin-bottom:10px;
    box-shadow:0 4px 8px rgba(15, 23, 42, 0.04);
    page-break-inside: avoid;
  }
  .card-header{
    display:flex;
    justify-content:space-between;
    gap:10px;
    margin-bottom:6px;
    border-bottom:1px solid rgba(226,232,240,0.6);
    padding-bottom:4px;
  }
  .card-title{
    font-weight:bold;
    color:var(--title);
  }
  .meta{
    display:flex;
    gap:6px;
    flex-wrap:wrap;
    margin-bottom:5px;
  }
  .badge{
    border-radius:9999px;
    padding:2px 9px 1px;
    font-size:11px;
    border:1px solid rgba(0,0,0,0.03);
  }
  .badge.teacher{background:var(--badge1);border-color:var(--badge1-border);}
  .badge.stage{background:var(--badge2);border-color:var(--badge2-border);}
  .badge.type{background:var(--badge3);border-color:var(--badge3-border);}
  .badge.month{background:var(--badge4);border-color:var(--badge4-border);}
  .topics{
    margin-top:4px;
    white-space:pre-line;
    line-height:1.5;
    background:#f8fafc;
    border:1px solid #e2e8f0;
    border-radius:6px;
    padding:6px;
  }
  .muted{
    color:var(--muted);
    font-size:11px;
  }
  .num-circle{
    min-width:22px;
    height:22px;
    background:var(--accent);
    color:#fff;
    border-radius:999px;
    text-align:center;
    line-height:22px;
    font-size:11px;
    margin-left:6px;
    display:inline-block;
  }
  @media print {
    .toolbar{display:none;}
    body{margin:0;background:#fff;}
    .card{box-shadow:none;border:1px solid #e5e7eb;}
  }
</style>
</head>
<body>

<div class="toolbar">
  <button onclick="window.print()">🖨 طباعة / حفظ PDF</button>
</div>

<h2>المواد الداخلة بالامتحان</h2>
<div class="subhead">
  <?php if ($sel_type !== ''): ?>
    نوع الامتحان: <strong><?php echo htmlspecialchars($sel_type, ENT_QUOTES, 'UTF-8'); ?></strong>
  <?php endif; ?>
  <?php if ($sel_month !== ''): ?>
    &nbsp; | &nbsp; الشهر: <strong><?php echo htmlspecialchars($sel_month, ENT_QUOTES, 'UTF-8'); ?></strong>
  <?php endif; ?>
  <br>
  تم التوليد بتاريخ: <?php echo date('Y-m-d H:i'); ?>
</div>

<?php if (count($topics) === 0): ?>
  <p style="text-align:center;margin-top:20px;">لا توجد بيانات لهذا الفلتر.</p>
<?php else: ?>
  <?php $i=1; foreach ($topics as $row): ?>
    <div class="card">
      <div class="card-header">
        <div>
          <span class="num-circle"><?php echo $i++; ?></span>
          <span class="card-title">
            <?php
              if ($row['teacher_subject'] != '') {
                  echo htmlspecialchars($row['teacher_subject'], ENT_QUOTES, 'UTF-8');
              } else {
                  echo 'مادة غير محددة';
              }
            ?>
          </span>
        </div>
        <div class="muted">
          التاريخ: <?php echo htmlspecialchars($row['created_at'], ENT_QUOTES, 'UTF-8'); ?>
        </div>
      </div>

      <div class="meta">
        <span class="badge teacher">
          المدرّس:
          <?php echo $row['teacher_name'] != '' ? htmlspecialchars($row['teacher_name'], ENT_QUOTES, 'UTF-8') : 'غير مذكور'; ?>
        </span>
        <span class="badge stage">
          المرحلة:
          <?php echo $row['stage'] != '' ? htmlspecialchars($row['stage'], ENT_QUOTES, 'UTF-8') : '—'; ?>
        </span>
        <span class="badge type">
          نوع الامتحان:
          <?php echo $row['exam_type'] != '' ? htmlspecialchars($row['exam_type'], ENT_QUOTES, 'UTF-8') : '—'; ?>
        </span>
        <span class="badge month">
          الشهر:
          <?php echo $row['exam_month'] != '' ? htmlspecialchars($row['exam_month'], ENT_QUOTES, 'UTF-8') : '—'; ?>
        </span>
      </div>

      <div class="topics">
        <strong style="display:block;margin-bottom:3px;color:var(--title);">المادة الداخلة:</strong>
        <?php
          echo $row['topics'] != ''
            ? nl2br(htmlspecialchars($row['topics'], ENT_QUOTES, 'UTF-8'))
            : '—';
        ?>
      </div>
    </div>
  <?php endforeach; ?>
<?php endif; ?>

</body>
</html>
