<?php
session_start();
include 'db.php';
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

mysqli_set_charset($conn, "utf8mb4");
function esc($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// ✅ تصدير جميع المواد إلى ملف Excel واحد
if (isset($_GET['download']) && $_GET['download'] === 'all_excel') {
    require 'vendor/autoload.php';
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    $spreadsheet = new Spreadsheet();

    // جلب جميع المواد من جدول teachers (لكل المراحل)
    $subjects_rs = mysqli_query($conn, "SELECT DISTINCT subject FROM teachers WHERE subject<>'' ORDER BY subject");
    $subjects = [];
    while ($r = mysqli_fetch_assoc($subjects_rs)) $subjects[] = $r['subject'];

    // في حال لم توجد مواد
    if (count($subjects) === 0) {
        die("❌ لا توجد مواد مسجلة في النظام.");
    }

    $sheetIndex = 0;

    foreach ($subjects as $subject) {
        // إنشاء ورقة جديدة لكل مادة
        if ($sheetIndex === 0) {
            $sheet = $spreadsheet->getActiveSheet();
            $sheet->setTitle(mb_substr($subject, 0, 30));
        } else {
            $sheet = $spreadsheet->createSheet();
            $sheet->setTitle(mb_substr($subject, 0, 30));
        }

        // رؤوس الأعمدة
        $headers = ['اسم الطالب','المرحلة','الشعبة','المادة','ش1','ش2','ش3','فصل1','نصفي','فصل2','معدل سنوي','النتيجة النهائية','تاريخ الحفظ'];
        $col = 'A';
        foreach ($headers as $head) {
            $sheet->setCellValue($col.'1', $head);
            $col++;
        }

        // جلب درجات المادة الحالية
        $subject_esc = mysqli_real_escape_string($conn, $subject);
        $query = "
            SELECT s.name, s.stage, s.class, g.month1, g.month2, g.month3, g.semester1,
                   g.midterm, g.semester2, g.annual_average, g.final_result, g.saved_at
            FROM students s
            LEFT JOIN grades g ON s.id = g.student_id
            WHERE TRIM(LOWER(REPLACE(g.subject,'ال',''))) = TRIM(LOWER(REPLACE('$subject_esc','ال','')))
            ORDER BY s.stage, s.class, s.name ASC
        ";
        $result = mysqli_query($conn, $query);

        $i = 2;
        while ($r = mysqli_fetch_assoc($result)) {
            $sheet->setCellValue("A$i", $r['name']);
            $sheet->setCellValue("B$i", $r['stage']);
            $sheet->setCellValue("C$i", $r['class']);
            $sheet->setCellValue("D$i", $subject);
            $sheet->setCellValue("E$i", $r['month1']);
            $sheet->setCellValue("F$i", $r['month2']);
            $sheet->setCellValue("G$i", $r['month3']);
            $sheet->setCellValue("H$i", $r['semester1']);
            $sheet->setCellValue("I$i", $r['midterm']);
            $sheet->setCellValue("J$i", $r['semester2']);
            $sheet->setCellValue("K$i", $r['annual_average']);
            $sheet->setCellValue("L$i", $r['final_result']);
            $sheet->setCellValue("M$i", $r['saved_at']);
            $i++;
        }

        // تنسيق الأعمدة
        foreach (range('A','M') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }
        $sheet->getStyle('A1:M1')->getFont()->setBold(true);

        $sheetIndex++;
    }

    // إعداد الملف للتنزيل
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=all_grades_export.xlsx");
    header('Cache-Control: max-age=0');
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();
}

// ✅ الواجهة العامة (زر التصدير فقط)
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تصدير درجات الطلبة</title>
<style>
body{font-family:'Cairo',Arial;background:#f5f6fa;margin:0;padding:0;text-align:center;direction:rtl}
.container{max-width:700px;margin:100px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 10px 25px rgba(0,0,0,0.08)}
h1{color:#2d6cdf;margin-bottom:20px}
p{color:#555}
.btn{display:inline-block;background:#27ae60;color:#fff;text-decoration:none;padding:12px 24px;font-size:16px;border-radius:8px;margin-top:20px}
.btn:hover{background:#219150}
</style>
</head>
<body>
<div class="container">
<h1>📘 تصدير جميع درجات الطلبة</h1>
<p>يمكنك تنزيل ملف Excel يحتوي على جميع المواد، حيث يتم إنشاء ورقة مستقلة لكل مادة.</p>
<a href="?download=all_excel" class="btn">⬇️ تصدير كل المواد إلى Excel</a>
</div>
</body>
</html>
