<?php
session_start();
include 'db.php';

// ✅ التحقق من تسجيل الدخول
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

$teacher_id = $_SESSION['teacher_id'];

// ✅ جلب اسم المادة الخاصة بالمدرس
$subject_name = '';
$q = mysqli_query($conn, "SELECT subject FROM teachers WHERE id='$teacher_id' LIMIT 1");
if ($q && mysqli_num_rows($q) > 0) {
    $subject_name = mysqli_fetch_assoc($q)['subject'];
}

// ✅ استقبال المرحلة والشعبة
$stage = isset($_GET['stage']) ? trim($_GET['stage']) : '';
$class = isset($_GET['class']) ? trim($_GET['class']) : '';

if ($stage == '' || $class == '') {
    die("<div style='color:red;text-align:center;font-family:Cairo;margin-top:50px;'>❌ لم يتم تحديد المرحلة أو الشعبة.</div>");
}

// ✅ تنظيف اسم الشعبة
if (strpos($class, ':') !== false) {
    $parts = explode(':', $class);
    $class = trim(end($parts));
}
$class = str_replace(":", "", $class);

// ✅ جلب الطلاب مرتبين حسب الشعبة ثم الاسم
if ($class == 'جميع الشعب' || strtolower($class) == 'all') {
    $sql_students = "
        SELECT * FROM students 
        WHERE REPLACE(stage,'الأ','ا') LIKE REPLACE('%$stage%','الأ','ا') 
        ORDER BY class ASC, name ASC
    ";
} else {
    $sql_students = "
        SELECT * FROM students 
        WHERE REPLACE(stage,'الأ','ا') LIKE REPLACE('%$stage%','الأ','ا') 
          AND class='$class' 
        ORDER BY class ASC, name ASC
    ";
}
$result_students = mysqli_query($conn, $sql_students);

// ✅ حفظ التقييمات
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $saved_count = 0;

    foreach ($_POST['evaluations'] as $student_id => $ev) {
        $behavior = isset($ev['behavior']) ? mysqli_real_escape_string($conn, $ev['behavior']) : '';
        $academic = isset($ev['academic']) ? mysqli_real_escape_string($conn, $ev['academic']) : '';
        $note_behavior = isset($ev['note_behavior']) ? mysqli_real_escape_string($conn, $ev['note_behavior']) : '';
        $note_academic = isset($ev['note_academic']) ? mysqli_real_escape_string($conn, $ev['note_academic']) : '';

        if ($behavior == '' && $academic == '' && $note_behavior == '' && $note_academic == '') {
            continue;
        }

        $notes = "سلوك: $note_behavior\nدراسة: $note_academic";

        $check = mysqli_query($conn, "SELECT id FROM evaluations WHERE student_id='$student_id' AND teacher_id='$teacher_id' AND subject='$subject_name' LIMIT 1");
        if ($check && mysqli_num_rows($check) > 0) {
            mysqli_query($conn, "
                UPDATE evaluations 
                SET behavior='$behavior', academic_level='$academic', notes='$notes', updated_at=NOW()
                WHERE student_id='$student_id' AND teacher_id='$teacher_id' AND subject='$subject_name'
            ");
        } else {
            mysqli_query($conn, "
                INSERT INTO evaluations (student_id, teacher_id, subject, behavior, academic_level, notes, created_at)
                VALUES ('$student_id', '$teacher_id', '$subject_name', '$behavior', '$academic', '$notes', NOW())
            ");
        }

        $saved_count++;
    }

    if ($saved_count > 0) {
        echo "<script>alert('✅ تم حفظ $saved_count تقييم فقط تحتوي على بيانات فعلية في مادة ($subject_name).');</script>";
        $success = "✅ تم حفظ <strong>$saved_count</strong> تقييم فقط تحتوي على بيانات فعلية في مادة <strong>$subject_name</strong>.";
    } else {
        echo "<script>alert('⚠️ لم يتم حفظ أي تقييم لأن جميع الحقول فارغة.');</script>";
        $success = "⚠️ لم يتم حفظ أي تقييم لأن جميع الحقول فارغة.";
    }
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>تقييم الطلبة - <?php echo htmlspecialchars($stage); ?> - <?php echo htmlspecialchars($class); ?></title>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
<style>
body{font-family:"Cairo",Arial,sans-serif;direction:rtl;background:#f2f3f7;margin:0;padding:0;}
.container{width:95%;max-width:1200px;margin:40px auto;background:#fff;padding:25px 35px;border-radius:12px;box-shadow:0 10px 25px rgba(0,0,0,0.1);}
h2{background:#007bff;color:#fff;padding:12px;text-align:center;border-radius:8px;margin-bottom:25px;}
.notice{background:#fff3cd;color:#856404;border:1px solid #ffeeba;padding:10px;text-align:center;border-radius:8px;margin-bottom:15px;}
.success{background:#d4edda;border:1px solid #c3e6cb;color:#155724;padding:10px;text-align:center;border-radius:8px;margin-bottom:15px;}
table{width:100%;border-collapse:collapse;margin-bottom:20px;}
th,td{border:1px solid #ddd;padding:8px;text-align:center;font-size:14px;}
th{background:#007bff;color:#fff;}
td.class-col{font-weight:bold;color:#0069d9;}
select,textarea{padding:5px;border-radius:6px;border:1px solid #ccc;font-family:"Cairo";}
textarea{width:100%;resize:none;}
button{background:#28a745;color:#fff;padding:10px 25px;border:none;border-radius:6px;font-size:16px;cursor:pointer;transition:0.3s;}
button:hover{background:#218838;}
a.back{display:inline-block;background:#007bff;color:#fff;padding:8px 15px;text-decoration:none;border-radius:6px;margin-top:15px;}
a.back:hover{background:#0056b3;}
.no-data{color:red;text-align:center;font-weight:bold;}
</style>
</head>
<body>
<div class="container">
<h2>تقييم الطلبة - المرحلة: <?php echo htmlspecialchars($stage); ?> - الشعبة: <?php echo htmlspecialchars($class); ?></h2>
<h3 style="text-align:center;color:#007bff;">📘 المادة: <?php echo htmlspecialchars($subject_name ?: 'غير محددة'); ?></h3>

<?php 
if(isset($success)) echo "<div class='success'>$success</div>"; 
echo "<div class='notice'>⚠️ سيتم حفظ فقط الصفوف التي تحتوي على تقييم فعلي أو ملاحظات، ولن يتم حفظ الصفوف الفارغة.</div>";
?>

<form method="post">
<table>
<tr>
<th>#</th>
<th>اسم الطالب</th>
<th>الشعبة</th>
<th>تقييم السلوك</th>
<th>ملاحظة السلوك</th>
<th>المستوى الدراسي</th>
<th>ملاحظة المستوى</th>
<th>📅 آخر تحديث</th>
</tr>

<?php
$counter = 1;
if ($result_students && mysqli_num_rows($result_students) > 0) {
    while($s = mysqli_fetch_assoc($result_students)) {
        $id = $s['id'];
        $ev = mysqli_query($conn, "SELECT * FROM evaluations WHERE student_id='$id' AND teacher_id='$teacher_id' AND subject='$subject_name' LIMIT 1");
        $evaluation = $ev && mysqli_num_rows($ev) > 0 ? mysqli_fetch_assoc($ev) : [];

        $behavior = isset($evaluation['behavior']) ? $evaluation['behavior'] : '';
        $academic = isset($evaluation['academic_level']) ? $evaluation['academic_level'] : '';
        $notes = isset($evaluation['notes']) ? $evaluation['notes'] : '';
        $updated = isset($evaluation['updated_at']) ? date('Y-m-d H:i', strtotime($evaluation['updated_at'])) : '-';

        $note_behavior = '';
        $note_academic = '';
        if ($notes != '') {
            if (preg_match('/سلوك:(.*)/u', $notes, $m1)) $note_behavior = trim($m1[1]);
            if (preg_match('/دراسة:(.*)/u', $notes, $m2)) $note_academic = trim($m2[1]);
        }

        echo "<tr>
            <td>$counter</td>
            <td>".htmlspecialchars($s['name'])."</td>
            <td class='class-col'>".htmlspecialchars($s['class'])."</td>
            <td>
                <select name='evaluations[$id][behavior]'>
                    <option value=''>اختر</option>
                    <option value='ضعيف' ".($behavior=='ضعيف'?'selected':'').">ضعيف</option>
                    <option value='متوسط' ".($behavior=='متوسط'?'selected':'').">متوسط</option>
                    <option value='جيد' ".($behavior=='جيد'?'selected':'').">جيد</option>
                    <option value='جيد جداً' ".($behavior=='جيد جداً'?'selected':'').">جيد جداً</option>
                    <option value='ممتاز' ".($behavior=='ممتاز'?'selected':'').">ممتاز</option>
                </select>
            </td>
            <td><textarea name='evaluations[$id][note_behavior]' rows='1' placeholder='ملاحظة عن السلوك...'>".htmlspecialchars($note_behavior)."</textarea></td>
            <td>
                <select name='evaluations[$id][academic]'>
                    <option value=''>اختر</option>
                    <option value='ضعيف' ".($academic=='ضعيف'?'selected':'').">ضعيف</option>
                    <option value='متوسط' ".($academic=='متوسط'?'selected':'').">متوسط</option>
                    <option value='جيد' ".($academic=='جيد'?'selected':'').">جيد</option>
                    <option value='جيد جداً' ".($academic=='جيد جداً'?'selected':'').">جيد جداً</option>
                    <option value='ممتاز' ".($academic=='ممتاز'?'selected':'').">ممتاز</option>
                </select>
            </td>
            <td><textarea name='evaluations[$id][note_academic]' rows='1' placeholder='ملاحظة عن المستوى...'>".htmlspecialchars($note_academic)."</textarea></td>
            <td>$updated</td>
        </tr>";
        $counter++;
    }
} else {
    echo "<tr><td colspan='8' class='no-data'>❌ لا توجد بيانات للطلاب في هذه المرحلة أو الشعبة.</td></tr>";
}
?>
</table>

<div style="text-align:center;">
    <button type="submit">💾 حفظ التقييمات</button>
</div>
</form>

<p style="text-align:center;">
    <a class="back" href="dashboard.php">⬅ العودة إلى لوحة التحكم</a>
</p>
</div>
</body>
</html>
