<?php
session_start();
include 'db.php';

// ✅ التحقق من تسجيل دخول المدرّس
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

// ✅ بيانات المدرّس من الجلسة
$teacher_name    = isset($_SESSION['teacher_name']) ? $_SESSION['teacher_name'] : 'مدرّس';
$teacher_subject = isset($_SESSION['teacher_subject']) ? $_SESSION['teacher_subject'] : '';

// ✅ نضبط التوقيت
date_default_timezone_set('Asia/Baghdad');

// =============== ⏱️ من هنا منطق الوقت ===============
// اليوم الحالي
$now     = time();
$today   = date('Y-m-d');

// يفتح 7 صباحاً
$open_ts  = strtotime($today . ' 07:00:00');
// 🔴 يغلق 11 صباحاً
$close_ts = strtotime($today . ' 11:00:00');

// هل النظام مفتوح الآن؟
$is_homework_open = ($now >= $open_ts && $now < $close_ts);

// نحدد وقت العداد
if ($is_homework_open) {
    // عداد للإغلاق (يبين كم باقي للـ 11 صباحاً)
    $countdown_ts = $close_ts;
} else {
    // لو بعد 11 الظهر → يفتح باچر 7 الصبح
    if ($now >= $close_ts) {
        $tomorrow = date('Y-m-d', strtotime('+1 day'));
        $countdown_ts = strtotime($tomorrow . ' 07:00:00');
    } else {
        // لو قبل 7 الصبح → يفتح اليوم 7
        $countdown_ts = $open_ts;
    }
}

// نخليه بصيغة ISO عشان الجافاسكربت تقراه بسهولة
$countdown_str = date('Y-m-d\TH:i:s', $countdown_ts);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📘 لوحة تحكم المدرّس</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  display:flex;
  flex-direction:column;
  overflow-x:hidden;
}
body::before{
  content:"";
  position:fixed;
  top:-50%;
  left:-50%;
  width:200%;
  height:200%;
  background:
    radial-gradient(circle at 30% 30%,rgba(0,255,255,0.2),transparent 70%),
    radial-gradient(circle at 70% 70%,rgba(255,215,0,0.2),transparent 80%),
    radial-gradient(circle at 50% 100%,rgba(138,43,226,0.15),transparent 60%);
  animation:nebula 25s linear infinite alternate;
  filter:blur(90px);
  z-index:-1;
}
@keyframes nebula{0%{transform:rotate(0deg) scale(1)}100%{transform:rotate(360deg) scale(1.2)}}

header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:18px 25px;
  background:rgba(255,255,255,0.07);
  border-bottom:1px solid rgba(255,255,255,0.12);
  backdrop-filter:blur(10px);
  box-shadow:0 2px 12px rgba(0,255,255,0.1);
  position:sticky;
  top:0;
  z-index:10;
}
header .left{display:flex;align-items:center;gap:12px}
header img{height:45px;border-radius:50%;box-shadow:0 0 10px rgba(0,255,255,0.3)}
header h1{font-size:20px;font-weight:600;color:#fff;margin:0}
header .user{font-size:14px;color:#0ff;opacity:0.85}
header .btn{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;padding:9px 18px;border-radius:10px;
  text-decoration:none;font-weight:bold;transition:0.3s;
}
header .btn:hover{transform:scale(1.05);box-shadow:0 0 15px rgba(0,255,255,0.4)}

.intro{
  text-align:center;
  margin:40px auto 20px;
  padding:15px 10px;
  max-width:900px;
  position:relative;
  z-index:2;
  opacity:0;
  animation:fadeIn 1.2s ease-in-out forwards;
}
.intro h2{
  font-size:26px;
  color:#00e6ff;
  text-shadow:0 0 15px rgba(0,255,255,0.4);
  margin-bottom:10px;
}
.intro p{
  color:#ddd;
  font-size:16px;
  line-height:1.7;
}
.intro .sub{
  color:#aaa;
  font-size:14px;
  margin-top:8px;
}
@keyframes fadeIn{
  from{opacity:0;transform:translateY(20px)}
  to{opacity:1;transform:translateY(0)}
}

main{
  flex:1;
  width:100%;
  max-width:1200px;
  margin:20px auto 50px;
  padding:0 20px;
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:25px;
  animation:fadeIn 1.4s ease-in-out forwards;
}

.card-link{
  text-decoration:none;
  color:inherit;
}
.card{
  background:rgba(255,255,255,0.08);
  border-radius:22px;
  padding:25px 20px;
  text-align:center;
  border:1px solid rgba(255,255,255,0.12);
  box-shadow:0 0 20px rgba(0,255,255,0.08);
  transition:0.4s;
  position:relative;
  overflow:hidden;
  cursor:pointer;
}
.card::before{
  content:"";
  position:absolute;
  top:-100%;left:0;width:100%;height:100%;
  background:linear-gradient(180deg,rgba(255,255,255,0.2),transparent);
  transition:0.6s;
}
.card:hover::before{top:0}
.card:hover{
  transform:translateY(-6px);
  box-shadow:0 0 30px rgba(0,255,255,0.3);
  background:rgba(255,255,255,0.12);
}
.icon{
  font-size:40px;
  margin-bottom:14px;
  color:#00e6ff;
  text-shadow:0 0 15px rgba(0,255,255,0.7);
}
.card h3{font-size:18px;margin-bottom:10px}
.card p{color:#ccc;font-size:14px;margin-bottom:5px;min-height:40px}

.card.disabled{
  background:rgba(255,255,255,0.03);
  border:1px dashed rgba(255,255,255,0.15);
  cursor:not-allowed;
}
.card.disabled:hover{
  transform:none;
  box-shadow:none;
  background:rgba(255,255,255,0.04);
}

/* ✅ شارة الوقت */
.timer-badge{
  position:absolute;
  top:12px;
  right:12px;
  background:rgba(0,0,0,0.35);
  border:1px solid rgba(0,230,255,0.4);
  padding:4px 10px;
  border-radius:999px;
  font-size:11px;
  color:#fff;
}
.timer-badge.off{
  background:rgba(255,0,74,0.35);
  border:1px solid rgba(255,0,74,0.6);
}

footer{
  text-align:center;
  padding:15px;
  font-size:13px;
  color:#aaa;
  background:rgba(255,255,255,0.04);
  backdrop-filter:blur(8px);
  border-top:1px solid rgba(255,255,255,0.08);
}
footer span{color:#00e6ff}

@media (max-width:600px){
  header{flex-direction:column;gap:8px;text-align:center}
  header .left{flex-direction:column;gap:6px}
  main{margin:20px auto;padding:0 15px;gap:20px}
}
</style>
</head>
<body>

<header>
  <div class="left">
    <img src="logo.png" alt="logo">
    <div>
      <h1>لوحة تحكم المدرّس</h1>
      <div class="user">مرحباً، <?php echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8'); ?><?php
        if ($teacher_subject != '') {
            echo " — " . htmlspecialchars($teacher_subject, ENT_QUOTES, 'UTF-8');
        }
      ?></div>
    </div>
  </div>
  <a href="logout.php" class="btn">تسجيل خروج</a>
</header>

<section class="intro">
  <h2>👨‍🏫 لوحة المدرّس</h2>
  <p>من هنا تدخل لكل أنظمة المدرسة المرتبطة باسمك.</p>
  <p class="sub">اختر النظام المطلوب 👇</p>
</section>

<main>

  <!-- 1) نظام درجات الطلبة -->
  <a href="dashboard.php" class="card-link">
    <div class="card">
      <div class="icon">📚</div>
      <h3>نظام درجات الطلبة</h3>
      <p>إدخال ومراجعة الدرجات حسب المادة والمرحلة.</p>
    </div>
  </a>

  <!-- ✅ 2) إرسال الواجبات مع شرط الوقت (7 ص - 11 ص) -->
  <?php if ($is_homework_open): ?>
    <a href="homework.php" class="card-link" id="hw-card" data-countdown="<?php echo $countdown_str; ?>">
      <div class="card">
        <div class="timer-badge" id="hw-timer">جارٍ الحساب...</div>
        <div class="icon">📝</div>
        <h3>إرسال الواجبات</h3>
        <p>رفع واجبات للطلاب مع خيار الامتحان اليومي.</p>
      </div>
    </a>
  <?php else: ?>
    <div class="card disabled" id="hw-card" data-countdown="<?php echo $countdown_str; ?>">
      <div class="timer-badge off" id="hw-timer">مغلق الآن</div>
      <div class="icon">📝</div>
      <h3>إرسال الواجبات</h3>
      <p>هذا النظام متاح من 7 صباحاً إلى 11 صباحاً.</p>
    </div>
  <?php endif; ?>

  <!-- ✅ كارت رفع الأسئلة -->
  <a href="upload_questions.php" class="card-link">
    <div class="card">
      <div class="icon">📤</div>
      <h3>رفع الأسئلة</h3>
      <p>رفع PDF أو Word أو صورة لأسئلة الأشهر والفصول.</p>
    </div>
  </a>

  <a href="exam_topics.php" class="card-link">
    <div class="card">
      <div class="icon">📄</div>
      <h3>المادة الداخلة بالامتحان</h3>
      <p>إرسال المادة الداخلة بالامتحان.</p>
    </div>
  </a>

  <!-- 5) المكتبة المدرسية -->
  <a href="https://mosul.pw/alawael/" class="card-link" target="_blank" rel="noopener">
    <div class="card">
      <div class="icon">📖</div>
      <h3>المكتبة المدرسية</h3>
      <p>كتب ومصادر للمدرّس والطالب.</p>
    </div>
  </a>

</main>

<footer>
  © <span><?php echo date("Y"); ?></span> جميع الحقوق محفوظة — <b>ثانوية الأوائل الأهلية للبنين</b>
</footer>

<script>
// ⏱️ مؤقّت بسيط
(function(){
  var card  = document.getElementById('hw-card');
  var badge = document.getElementById('hw-timer');
  if (!card || !badge) return;

  var targetStr = card.getAttribute('data-countdown');
  if (!targetStr) return;

  function pad(n){ return n < 10 ? '0'+n : n; }

  function updateTimer(){
    var target = new Date(targetStr).getTime();
    var now    = new Date().getTime();
    var diff   = target - now;

    if (diff <= 0) {
      badge.textContent = 'انتهى الوقت';
      badge.className = 'timer-badge off';
      return;
    }

    var seconds = Math.floor(diff / 1000);
    var h = Math.floor(seconds / 3600);
    seconds = seconds % 3600;
    var m = Math.floor(seconds / 60);
    var s = seconds % 60;

    if (badge.className.indexOf('off') === -1) {
      badge.textContent = 'يغلق خلال: ' + pad(h) + ':' + pad(m) + ':' + pad(s);
    } else {
      badge.textContent = 'يفتح بعد: ' + pad(h) + ':' + pad(m) + ':' + pad(s);
    }
  }

  updateTimer();
  setInterval(updateTimer, 1000);
})();
</script>

</body>
</html>
