<?php
session_start();
include 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit(); }

$notice = "";

// ✅ جلب المراحل من الطلاب
$stages_rs = mysqli_query($conn, "SELECT DISTINCT stage FROM students ORDER BY stage");
$stages = array();
while($r = mysqli_fetch_assoc($stages_rs)) $stages[] = $r['stage'];

// ✅ جلب المدرسين
$teachers_rs = mysqli_query($conn, "SELECT id,name,subject FROM teachers ORDER BY name");
$teachers = array();
while($t = mysqli_fetch_assoc($teachers_rs)) $teachers[] = $t;

// ✅ إضافة مادة جديدة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_subject'])) {
    $name = mysqli_real_escape_string($conn, trim($_POST['name']));
    $code = mysqli_real_escape_string($conn, trim($_POST['code']));
    $stage = mysqli_real_escape_string($conn, trim($_POST['stage']));
    $teacher_id = isset($_POST['teacher_id']) ? (int)$_POST['teacher_id'] : 0;

    if ($name != '' && $teacher_id > 0) {
        $sql = "INSERT INTO subjects (name, code, stage, teacher_id)
                VALUES ('$name', '$code', '$stage', $teacher_id)";
        mysqli_query($conn, $sql);

        // ✅ تحديث حقل المادة في جدول المدرسين
        mysqli_query($conn, "UPDATE teachers SET subject='$name' WHERE id=$teacher_id");

        $notice = "✅ تم إضافة المادة وربطها بالمدرّس بنجاح.";
    } else {
        $notice = "⚠️ يرجى إدخال اسم المادة واختيار المدرّس.";
    }
}

// ✅ تعديل مادة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_subject'])) {
    $id = (int)$_POST['id'];
    $name = mysqli_real_escape_string($conn, trim($_POST['name']));
    $code = mysqli_real_escape_string($conn, trim($_POST['code']));
    $stage = mysqli_real_escape_string($conn, trim($_POST['stage']));
    $teacher_id = isset($_POST['teacher_id']) ? (int)$_POST['teacher_id'] : 0;

    // ✅ جلب المدرّس القديم قبل التعديل
    $old_res = mysqli_query($conn, "SELECT teacher_id FROM subjects WHERE id=$id");
    $old_teacher_id = 0;
    if ($old_res && mysqli_num_rows($old_res) == 1) {
        $old = mysqli_fetch_assoc($old_res);
        $old_teacher_id = (int)$old['teacher_id'];
    }

    // ✅ التحديث في جدول المواد
    mysqli_query($conn, "UPDATE subjects SET name='$name', code='$code', stage='$stage', teacher_id=$teacher_id WHERE id=$id");

    // ✅ إذا تغيّر المدرّس، نفرغ المادة من القديم ونحدث الجديد
    if ($old_teacher_id != $teacher_id && $old_teacher_id > 0) {
        mysqli_query($conn, "UPDATE teachers SET subject='' WHERE id=$old_teacher_id");
    }

    if ($teacher_id > 0) {
        mysqli_query($conn, "UPDATE teachers SET subject='$name' WHERE id=$teacher_id");
    }

    $notice = "✅ تم تحديث المادة والمدرّس المرتبط بها.";
}

// ✅ حذف مادة
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];

    // ✅ جلب المدرس المرتبط قبل الحذف
    $old_res = mysqli_query($conn, "SELECT teacher_id FROM subjects WHERE id=$id");
    if ($old_res && mysqli_num_rows($old_res) == 1) {
        $old = mysqli_fetch_assoc($old_res);
        $old_teacher_id = (int)$old['teacher_id'];
        if ($old_teacher_id > 0) {
            mysqli_query($conn, "UPDATE teachers SET subject='' WHERE id=$old_teacher_id");
        }
    }

    // ✅ حذف المادة
    mysqli_query($conn, "DELETE FROM subjects WHERE id=$id");
    $notice = "🗑️ تم حذف المادة وتم إزالة الربط من المدرّس.";
}

// ✅ جلب المواد مع المدرسين
$subjects = mysqli_query($conn, "
    SELECT s.*, t.name AS teacher_name
    FROM subjects s
    LEFT JOIN teachers t ON s.teacher_id = t.id
    ORDER BY s.id DESC
");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة المواد الدراسية</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:Tahoma,Arial;background:#f5f6fa;margin:0}
.top{display:flex;justify-content:space-between;align-items:center;padding:12px 16px;background:#fff;border-bottom:1px solid #eee}
.container{max-width:1200px;margin:20px auto;padding:0 16px}
.card{background:#fff;border:1px solid #eee;border-radius:16px;box-shadow:0 5px 20px rgba(0,0,0,.05);padding:20px;margin-bottom:20px}
h2{margin-top:0}
table{width:100%;border-collapse:collapse}
th,td{border-bottom:1px solid #eee;padding:8px;text-align:right;font-size:14px}
.btn{display:inline-block;background:#2d6cdf;color:#fff;text-decoration:none;padding:8px 12px;border-radius:10px;margin:4px}
.btn.red{background:#c0392b}
input,select{width:100%;padding:8px;border-radius:8px;border:1px solid #ccc;margin-bottom:8px}
.notice{background:#eaf7ee;border:1px solid #c6efd1;color:#2a7d2e;padding:10px;border-radius:10px;margin-bottom:12px}
</style>
</head>
<body>
  <div class="top">
    <div><strong>إدارة المواد الدراسية</strong></div>
    <div>
      <a class="btn" href="admin_dashboard.php">العودة للوحة</a>
      <a class="btn red" href="admin_logout.php">خروج</a>
    </div>
  </div>
  <div class="container">
    <?php if($notice!==""):?><div class="notice"><?php echo htmlspecialchars($notice);?></div><?php endif;?>

    <div class="card">
      <h2>إضافة مادة جديدة</h2>
      <form method="post">
        <label>اسم المادة:</label>
        <input type="text" name="name" required>
        <label>رمز المادة (اختياري):</label>
        <input type="text" name="code">
        <label>المرحلة الدراسية:</label>
        <select name="stage">
          <option value="">اختر مرحلة</option>
          <?php foreach($stages as $s): ?>
          <option value="<?php echo htmlspecialchars($s); ?>"><?php echo htmlspecialchars($s); ?></option>
          <?php endforeach; ?>
        </select>
        <label>المدرّس:</label>
        <select name="teacher_id" required>
          <option value="">اختر المدرّس</option>
          <?php foreach($teachers as $t): ?>
          <option value="<?php echo $t['id']; ?>"><?php echo htmlspecialchars($t['name']); ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn" name="add_subject">إضافة المادة</button>
      </form>
    </div>

    <div class="card">
      <h2>قائمة المواد</h2>
      <table>
        <thead>
          <tr><th>#</th><th>اسم المادة</th><th>رمز</th><th>المرحلة</th><th>المدرّس</th><th>تحكم</th></tr>
        </thead>
        <tbody>
          <?php while($r = mysqli_fetch_assoc($subjects)): ?>
          <tr>
            <td><?php echo $r['id']; ?></td>
            <td><?php echo htmlspecialchars($r['name']); ?></td>
            <td><?php echo htmlspecialchars($r['code']); ?></td>
            <td><?php echo htmlspecialchars($r['stage']); ?></td>
            <td><?php echo htmlspecialchars($r['teacher_name']); ?></td>
            <td>
              <a class="btn" href="?edit=<?php echo $r['id']; ?>">✏️ تعديل</a>
              <a class="btn red" href="?delete=<?php echo $r['id']; ?>" onclick="return confirm('هل أنت متأكد من حذف هذه المادة؟')">🗑️ حذف</a>
            </td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

    <?php
    // ✅ نافذة تعديل المادة
    if (isset($_GET['edit'])) {
        $id = (int)$_GET['edit'];
        $res = mysqli_query($conn, "SELECT * FROM subjects WHERE id=$id LIMIT 1");
        if ($res && mysqli_num_rows($res)==1) {
            $sub = mysqli_fetch_assoc($res);
    ?>
    <div class="card">
      <h2>تعديل المادة: <?php echo htmlspecialchars($sub['name']); ?></h2>
      <form method="post">
        <input type="hidden" name="id" value="<?php echo $sub['id']; ?>">
        <label>اسم المادة:</label>
        <input type="text" name="name" value="<?php echo htmlspecialchars($sub['name']); ?>" required>
        <label>رمز المادة:</label>
        <input type="text" name="code" value="<?php echo htmlspecialchars($sub['code']); ?>">
        <label>المرحلة الدراسية:</label>
        <select name="stage">
          <option value="">اختر مرحلة</option>
          <?php foreach($stages as $s): ?>
          <option value="<?php echo htmlspecialchars($s); ?>" <?php echo ($s==$sub['stage'])?'selected':''; ?>>
            <?php echo htmlspecialchars($s); ?>
          </option>
          <?php endforeach; ?>
        </select>
        <label>المدرّس:</label>
        <select name="teacher_id">
          <option value="">اختر المدرّس</option>
          <?php foreach($teachers as $t): ?>
          <option value="<?php echo $t['id']; ?>" <?php echo ($t['id']==$sub['teacher_id'])?'selected':''; ?>>
            <?php echo htmlspecialchars($t['name']); ?>
          </option>
          <?php endforeach; ?>
        </select>
        <button class="btn" name="update_subject">💾 حفظ التعديل</button>
      </form>
    </div>
    <?php }} ?>
  </div>
</body>
</html>
