<?php
session_start();
include 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit(); }

$notice = "";

/* ✅ إضافة طالب جديد */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_student'])) {
    $name = mysqli_real_escape_string($conn, trim($_POST['name']));
    $stage = mysqli_real_escape_string($conn, trim($_POST['stage']));
    $class = mysqli_real_escape_string($conn, trim($_POST['class']));

    if ($name != '' && $stage != '' && $class != '') {
        mysqli_query($conn, "INSERT INTO students (name, stage, class) VALUES ('$name', '$stage', '$class')");
        $notice = "✅ تم إضافة الطالب بنجاح.";
    } else {
        $notice = "⚠️ يرجى إدخال جميع الحقول.";
    }
}

/* ✅ تعديل بيانات طالب */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_student'])) {
    $id = (int)$_POST['id'];
    $name = mysqli_real_escape_string($conn, trim($_POST['name']));
    $stage = mysqli_real_escape_string($conn, trim($_POST['stage']));
    $class = mysqli_real_escape_string($conn, trim($_POST['class']));

    mysqli_query($conn, "UPDATE students SET name='$name', stage='$stage', class='$class' WHERE id=$id");
    $notice = "✅ تم تحديث بيانات الطالب.";
}

/* ✅ حذف طالب */
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    mysqli_query($conn, "DELETE FROM students WHERE id=$id");
    $notice = "🗑️ تم حذف الطالب بنجاح.";
}

/* ✅ استيراد طلاب من ملف CSV */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['import_csv'])) {
    if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $filename = $_FILES['file']['tmp_name'];
        $handle = fopen($filename, "r");

        if ($handle !== FALSE) {
            $line = 0;   // عداد للأسطر
            $added = 0;  // عداد للطلاب الذين تم إدخالهم

            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                $line++;

                // ✅ تخطي الصف الأول (رؤوس الأعمدة)
                if ($line == 1) continue;

                $name  = isset($data[0]) ? trim($data[0]) : '';
                $stage = isset($data[1]) ? trim($data[1]) : '';
                $class = isset($data[2]) ? trim($data[2]) : '';

                if ($name != '' && $stage != '' && $class != '') {
                    $name  = mysqli_real_escape_string($conn, $name);
                    $stage = mysqli_real_escape_string($conn, $stage);
                    $class = mysqli_real_escape_string($conn, $class);
                    mysqli_query($conn, "INSERT INTO students (name, stage, class) VALUES ('$name', '$stage', '$class')");
                    $added++;
                }
            }
            fclose($handle);
            $notice = "✅ تم استيراد عدد {$added} طالب بنجاح.";
        } else {
            $notice = "❌ تعذر قراءة الملف.";
        }
    } else {
        $notice = "⚠️ يرجى اختيار ملف CSV صحيح.";
    }
}

/* ✅ جلب جميع الطلاب */
$students = mysqli_query($conn, "SELECT * FROM students ORDER BY id DESC");

/* ✅ جلب المراحل */
$stages_rs = mysqli_query($conn, "SELECT DISTINCT stage FROM students ORDER BY stage");
$stages = array();
while($r = mysqli_fetch_assoc($stages_rs)) $stages[] = $r['stage'];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة الطلبة</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:'Tahoma',Arial,sans-serif;background:#f5f6fa;margin:0}
.top{display:flex;justify-content:space-between;align-items:center;padding:12px 16px;background:#fff;border-bottom:1px solid #eee}
.container{max-width:1200px;margin:20px auto;padding:0 16px}
.card{background:#fff;border:1px solid #eee;border-radius:16px;box-shadow:0 5px 20px rgba(0,0,0,.05);padding:20px;margin-bottom:20px}
h2{margin-top:0}
table{width:100%;border-collapse:collapse}
th,td{border-bottom:1px solid #eee;padding:8px;text-align:right;font-size:14px}
.btn{display:inline-block;background:#2d6cdf;color:#fff;text-decoration:none;padding:6px 10px;border-radius:8px;margin:2px;font-size:13px}
.btn.red{background:#c0392b}
input,select{width:100%;padding:8px;border-radius:8px;border:1px solid #ccc;margin-bottom:8px}
.notice{background:#eaf7ee;border:1px solid #c6efd1;color:#2a7d2e;padding:10px;border-radius:10px;margin-bottom:12px}
.edit-form{background:#f9faff;border:1px solid #dde2f5;padding:10px;border-radius:10px;margin-top:8px}
</style>
</head>
<body>
  <div class="top">
    <div><strong>📋 إدارة الطلبة</strong></div>
    <div>
      <a class="btn" href="admin_dashboard.php">🏠 العودة للوحة</a>
      <a class="btn red" href="admin_logout.php">🚪 خروج</a>
    </div>
  </div>

  <div class="container">
    <?php if($notice!==""):?>
      <div class="notice"><?php echo htmlspecialchars($notice);?></div>
    <?php endif;?>

    <!-- إضافة طالب يدوي -->
    <div class="card">
      <h2>➕ إضافة طالب جديد</h2>
      <form method="post">
        <label>اسم الطالب:</label>
        <input type="text" name="name" required>
        <label>المرحلة الدراسية:</label>
        <input type="text" name="stage" placeholder="مثال: الثالث المتوسط" required>
        <label>الشعبة:</label>
        <input type="text" name="class" placeholder="مثال: A" required>
        <button class="btn" name="add_student">إضافة الطالب</button>
      </form>
    </div>

    <!-- استيراد طلاب من ملف -->
    <div class="card">
      <h2>📂 استيراد طلاب من ملف Excel (CSV)</h2>
      <form method="post" enctype="multipart/form-data">
        <label>اختر ملف CSV يحتوي على الأعمدة: الاسم، المرحلة، الشعبة</label>
        <input type="file" name="file" accept=".csv" required>
        <button class="btn" name="import_csv">استيراد الملف</button>
      </form>
      <p style="color:#777;font-size:13px;">
        🔹 ملاحظة: احفظ الملف من Excel بصيغة <strong>CSV UTF-8</strong><br>
        (من Excel اختر: <em>حفظ باسم → CSV UTF-8 (Comma delimited)</em>)
      </p>
    </div>

    <!-- قائمة الطلاب -->
    <div class="card">
      <h2>📚 قائمة الطلبة</h2>
      <table>
        <thead>
          <tr>
            <th>#</th><th>الاسم</th><th>المرحلة</th><th>الشعبة</th><th>تحكم</th>
          </tr>
        </thead>
        <tbody>
          <?php while($r = mysqli_fetch_assoc($students)): ?>
          <tr>
            <td><?php echo $r['id']; ?></td>
            <td><?php echo htmlspecialchars($r['name']); ?></td>
            <td><?php echo htmlspecialchars($r['stage']); ?></td>
            <td><?php echo htmlspecialchars($r['class']); ?></td>
            <td>
              <a class="btn" href="?edit=<?php echo $r['id']; ?>">✏️ تعديل</a>
              <a class="btn red" href="?delete=<?php echo $r['id']; ?>" onclick="return confirm('هل تريد حذف هذا الطالب؟')">🗑️ حذف</a>
            </td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

    <!-- نموذج التعديل -->
    <?php
    if (isset($_GET['edit'])) {
        $id = (int)$_GET['edit'];
        $res = mysqli_query($conn, "SELECT * FROM students WHERE id=$id LIMIT 1");
        if ($res && mysqli_num_rows($res)==1) {
            $st = mysqli_fetch_assoc($res);
    ?>
    <div class="card">
      <h2>✏️ تعديل بيانات الطالب: <?php echo htmlspecialchars($st['name']); ?></h2>
      <form method="post" class="edit-form">
        <input type="hidden" name="id" value="<?php echo $st['id']; ?>">
        <label>اسم الطالب:</label>
        <input type="text" name="name" value="<?php echo htmlspecialchars($st['name']); ?>" required>
        <label>المرحلة الدراسية:</label>
        <input type="text" name="stage" value="<?php echo htmlspecialchars($st['stage']); ?>" required>
        <label>الشعبة:</label>
        <input type="text" name="class" value="<?php echo htmlspecialchars($st['class']); ?>" required>
        <button class="btn" name="update_student">💾 حفظ التعديل</button>
      </form>
    </div>
    <?php }} ?>
  </div>
</body>
</html>
