<?php 
session_start();
include 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit(); }
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>🛠️ لوحة تحكم الأدمن | ثانوية الأوائل الأهلية للبنين</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  display:flex;
  flex-direction:column;
  overflow-x:hidden;
}
body::before{
  content:"";
  position:fixed;
  top:-50%;
  left:-50%;
  width:200%;
  height:200%;
  background:
    radial-gradient(circle at 30% 30%,rgba(0,255,255,0.2),transparent 70%),
    radial-gradient(circle at 70% 70%,rgba(255,215,0,0.2),transparent 80%),
    radial-gradient(circle at 50% 100%,rgba(138,43,226,0.15),transparent 60%);
  animation:nebula 25s linear infinite alternate;
  filter:blur(90px);
  z-index:-1;
}
@keyframes nebula{0%{transform:rotate(0deg) scale(1)}100%{transform:rotate(360deg) scale(1.2)}}
header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:18px 25px;
  background:rgba(255,255,255,0.07);
  border-bottom:1px solid rgba(255,255,255,0.12);
  backdrop-filter:blur(10px);
  box-shadow:0 2px 12px rgba(0,255,255,0.1);
  position:sticky;
  top:0;
  z-index:10;
}
header .left{display:flex;align-items:center;gap:12px}
header img{height:45px;border-radius:50%;box-shadow:0 0 10px rgba(0,255,255,0.3)}
header h1{font-size:20px;font-weight:600;color:#fff;margin:0}
header .user{font-size:14px;color:#0ff;opacity:0.85}
header .btn{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;padding:9px 18px;border-radius:10px;
  text-decoration:none;font-weight:bold;transition:0.3s;
}
header .btn:hover{transform:scale(1.05);box-shadow:0 0 15px rgba(0,255,255,0.4)}
.intro{
  text-align:center;
  margin:40px auto 20px;
  padding:15px 10px;
  max-width:900px;
  position:relative;
  z-index:2;
  opacity:0;
  animation:fadeIn 1.2s ease-in-out forwards;
}
.intro h2{
  font-size:26px;
  color:#00e6ff;
  text-shadow:0 0 15px rgba(0,255,255,0.4);
  margin-bottom:10px;
}
.intro p{
  color:#ddd;
  font-size:16px;
  line-height:1.7;
}
.intro .sub{
  color:#aaa;
  font-size:14px;
  margin-top:8px;
}
@keyframes fadeIn{
  from{opacity:0;transform:translateY(20px)}
  to{opacity:1;transform:translateY(0)}
}
main{
  flex:1;
  width:100%;
  max-width:1200px;
  margin:20px auto 50px;
  padding:0 20px;
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:25px;
  animation:fadeIn 1.4s ease-in-out forwards;
}
.card-link{
  text-decoration:none;
  color:inherit;
}
.card{
  background:rgba(255,255,255,0.08);
  border-radius:22px;
  padding:25px 20px;
  text-align:center;
  border:1px solid rgba(255,255,255,0.12);
  box-shadow:0 0 20px rgba(0,255,255,0.08);
  transition:0.4s;
  position:relative;
  overflow:hidden;
  cursor:pointer;
}
.card::before{
  content:"";
  position:absolute;
  top:-100%;left:0;width:100%;height:100%;
  background:linear-gradient(180deg,rgba(255,255,255,0.2),transparent);
  transition:0.6s;
}
.card:hover::before{top:0}
.card:hover{
  transform:translateY(-6px);
  box-shadow:0 0 30px rgba(0,255,255,0.3);
  background:rgba(255,255,255,0.12);
}
.icon{
  font-size:40px;
  margin-bottom:14px;
  color:#00e6ff;
  text-shadow:0 0 15px rgba(0,255,255,0.7);
}
.card h3{font-size:18px;margin-bottom:10px}
.card p{color:#ccc;font-size:14px;margin-bottom:5px;min-height:40px}
footer{
  text-align:center;
  padding:15px;
  font-size:13px;
  color:#aaa;
  background:rgba(255,255,255,0.04);
  backdrop-filter:blur(8px);
  border-top:1px solid rgba(255,255,255,0.08);
}
footer span{color:#00e6ff}
@media (max-width:600px){
  header{flex-direction:column;gap:8px;text-align:center}
  header .left{flex-direction:column;gap:6px}
  main{margin:20px auto;padding:0 15px;gap:20px}
}
</style>
</head>
<body>

<header>
  <div class="left">
    <img src="logo.png" alt="logo">
    <div>
      <h1>لوحة تحكم الأدمن</h1>
      <div class="user">مرحباً، <?php echo htmlspecialchars($_SESSION['admin_username']); ?></div>
    </div>
  </div>
  <a href="admin_logout.php" class="btn">تسجيل خروج</a>
</header>

<section class="intro">
  <h2>🎓 ثانوية الأوائل الأهلية للبنين</h2>
  <p>مرحباً بك في لوحة القيادة الإدارية — حيث يبدأ تنظيم التميز والتفوق.</p>
  <p class="sub">من هنا يمكنك إدارة الكادر التدريسي، متابعة الطلبة، والإشراف على مسيرة المدرسة نحو القمة 🌟</p>
</section>

<main>
  <!-- إدارة المدرسين (باسورد 919929) -->
  <a href="#" class="card-link protected" data-pass="919929" data-target="admin_teachers.php">
    <div class="card">
      <div class="icon">👨‍🏫</div>
      <h3>إدارة المدرسين</h3>
      <p>إضافة وتعديل بيانات المدرسين والمراحل والشعب.</p>
    </div>
  </a>

  <!-- درجات الطلبة (09010901) -->
  <a href="#" class="card-link protected" data-pass="09010901" data-target="admin_grades.php">
    <div class="card">
      <div class="icon">📚</div>
      <h3>درجات الطلبة</h3>
      <p>مراجعة الدرجات حسب المرحلة والمادة والمدرس.</p>
    </div>
  </a>

  <!-- إدارة المواد الدراسية (919929) -->
  <a href="#" class="card-link protected" data-pass="919929" data-target="admin_subjects.php">
    <div class="card">
      <div class="icon">🧮</div>
      <h3>إدارة المواد الدراسية</h3>
      <p>إضافة وتعديل المواد لكل مرحلة.</p>
    </div>
  </a>

  <!-- إدارة الطلبة (919929) -->
  <a href="#" class="card-link protected" data-pass="919929" data-target="admin_students.php">
    <div class="card">
      <div class="icon">🎓</div>
      <h3>إدارة الطلبة</h3>
      <p>إضافة طالب جديد أو استيراد من Excel.</p>
    </div>
  </a>

  <!-- عرض الواجبات المدرسية (10202000) -->
  <a href="#" class="card-link protected" data-pass="10202000" data-target="homework_report.php">
    <div class="card">
      <div class="icon">📝</div>
      <h3>عرض الواجبات المدرسية</h3>
      <p>عرض واجبات اليوم، الامتحانات اليومية، والمدرسين الذين لم يرسلوا.</p>
    </div>
  </a>

  <!-- ✅ الكارت: المادة الداخلة بالامتحان -->
  <a href="admin_exam_topics.php" class="card-link">
    <div class="card">
      <div class="icon">📄🧠</div>
      <h3>المادة الداخلة بالامتحان</h3>
      <p>عرض ما أرسله المدرسون + نسخ + حذف + من لم يرسل.</p>
    </div>
  </a>

  <!-- ✅ الكارت: أسئلة المدرسين (محمي) -->
  <a href="#" class="card-link protected" data-pass="ali8319931" data-target="admin_questions_all.php">
    <div class="card">
      <div class="icon">📄</div>
      <h3>أسئلة المدرسين</h3>
      <p>عرض جميع الأسئلة المرفوعة من المدرسين + الإحصائيات.</p>
    </div>
  </a>

  <!-- ✅ الكارت: إحصائية الواجبات (بدون باسورد) -->
  <a href="homework_stats.php" class="card-link">
    <div class="card">
      <div class="icon">📒📈</div>
      <h3>إحصائية الواجبات</h3>
      <p>تقارير بعدد المدرسين الذين لم يرسلوا وأعلى الأيام وأداء المدرسين.</p>
    </div>
  </a>

  <!-- تقييمات الطلبة -->
  <a href="view_evaluations.php" class="card-link">
    <div class="card">
      <div class="icon">📊</div>
      <h3>تقييمات الطلبة</h3>
      <p>عرض تقييمات الطلبة والسلوك والملاحظات.</p>
    </div>
  </a>
  
  <!-- الإحصائيات -->
  <a href="admin_statistics.php" class="card-link">
    <div class="card">
      <div class="icon">📈</div>
      <h3>الإحصائيات والتحليل الأكاديمي</h3>
      <p>عرض نسب النجاح والرسوب والمتفوقين وتحليل أداء المدرسين والمواد.</p>
    </div>
  </a>

</main>

<footer>
  © <span><?php echo date("Y"); ?></span> جميع الحقوق محفوظة — <b>ثانوية الأوائل الأهلية للبنين</b>
</footer>

<script>
// ✅ حماية بسيطة على الكروت المحددة
document.querySelectorAll('.protected').forEach(function(card){
  card.addEventListener('click', function(e){
    e.preventDefault();
    var correctPass = this.getAttribute('data-pass');
    var target = this.getAttribute('data-target');
    var userPass = prompt("🔐 أدخل كلمة المرور لفتح هذه الصفحة:");
    if (userPass === null) return;
    if (userPass === correctPass) {
      window.location.href = target;
    } else {
      alert("❌ كلمة مرور غير صحيحة");
    }
  });
});
</script>

</body>
</html>
