<?php
session_start();
include 'db.php';

// ✅ التحقق من دخول الإدارة
if (!isset($_SESSION['admin_logged_in'])) {
    // مؤقتًا نسمح بالدخول للجميع
}

// ✅ عند إرسال النموذج لإضافة سجل جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['student_id'])) {
    $student_id   = intval($_POST['student_id']);
    $problem_type = mysqli_real_escape_string($conn, $_POST['problem_type']);
    $problem_note = mysqli_real_escape_string($conn, $_POST['problem_note']);
    $problem_date = mysqli_real_escape_string($conn, $_POST['problem_date']);
    $admin_name   = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : 'admin';

    // ✅ حساب عدد المخالفات السابقة
    $check = mysqli_query($conn, "SELECT COUNT(*) AS total FROM admin_behavior WHERE student_id='$student_id'");
    $count = ($check && mysqli_num_rows($check) > 0) ? mysqli_fetch_assoc($check)['total'] + 1 : 1;

    // ✅ إدخال سجل جديد
    mysqli_query($conn, "
        INSERT INTO admin_behavior (student_id, problem_type, problem_note, problem_date, problem_count, admin_name)
        VALUES ('$student_id', '$problem_type', '$problem_note', '$problem_date', '$count', '$admin_name')
    ");
    $success = "✅ تم حفظ المخالفة السلوكية للطالب بنجاح.";
}

// ✅ عند طلب الحذف
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $student_id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM admin_behavior WHERE student_id='$student_id'");
    $deleted = "🗑️ تم حذف جميع السجلات الخاصة بالطالب بنجاح.";
}

// ✅ جلب السجلات بدون تكرار
$records = mysqli_query($conn, "
    SELECT s.id AS student_id, s.name, s.stage, s.class, 
           COUNT(a.id) AS total_problems, MAX(a.problem_date) AS last_date
    FROM admin_behavior a
    JOIN students s ON a.student_id = s.id
    GROUP BY s.id
    ORDER BY s.stage, s.class, s.name
");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📋 سجل السلوك الإداري للطلبة</title>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
<style>
body{font-family:'Cairo',sans-serif;background:#eef1f5;margin:0;padding:0;direction:rtl;}
.container{max-width:1200px;margin:40px auto;background:#fff;border-radius:16px;padding:30px 40px;box-shadow:0 6px 20px rgba(0,0,0,0.1);}
h2{background:linear-gradient(90deg,#007bff,#0056b3);color:#fff;padding:14px;border-radius:10px;text-align:center;margin-bottom:30px;}
form{background:#f9fafc;border:1px solid #ddd;padding:20px;border-radius:10px;margin-bottom:25px;}
label{font-weight:600;color:#333;display:block;margin-bottom:6px;}
select,input,textarea{width:100%;padding:10px;border-radius:8px;border:1px solid #ccc;margin-bottom:15px;font-family:'Cairo';font-size:15px;}
button{background:#007bff;color:#fff;border:none;padding:10px 25px;border-radius:8px;font-size:16px;cursor:pointer;transition:0.3s;}
button:hover{background:#0056b3;}
.success,.deleted{background:#d4edda;color:#155724;border:1px solid #c3e6cb;padding:12px;text-align:center;border-radius:10px;margin-bottom:15px;}
.deleted{background:#f8d7da;color:#721c24;border-color:#f5c6cb;}
.note{background:#fff3cd;color:#856404;border:1px solid #ffeeba;padding:10px;text-align:center;border-radius:8px;margin-bottom:15px;}
.records{margin-top:30px;}
.table-container{overflow-x:auto;}
table{width:100%;border-collapse:collapse;margin-top:10px;}
th,td{border:1px solid #ddd;padding:10px;text-align:center;font-size:14px;}
th{background:#007bff;color:#fff;}
tr:nth-child(even){background:#f9f9f9;}
.badge{display:inline-block;padding:5px 10px;border-radius:10px;color:#fff;font-size:13px;}
.badge-danger{background:#dc3545;}
.badge-warning{background:#fd7e14;}
.badge-success{background:#28a745;}
a.details-btn{background:#17a2b8;color:#fff;padding:6px 10px;border-radius:6px;text-decoration:none;font-size:13px;}
a.details-btn:hover{background:#117a8b;}
a.delete-btn{background:#dc3545;color:#fff;padding:6px 10px;border-radius:6px;text-decoration:none;font-size:13px;}
a.delete-btn:hover{background:#b02a37;}
a.back{display:inline-block;background:#28a745;color:#fff;padding:10px 18px;text-decoration:none;border-radius:8px;margin-top:25px;}
a.back:hover{background:#1e7e34;}
.modal{display:none;position:fixed;z-index:1000;left:0;top:0;width:100%;height:100%;overflow:auto;background-color:rgba(0,0,0,0.4);}
.modal-content{background-color:#fff;margin:8% auto;padding:20px;border:1px solid #888;width:80%;max-width:750px;border-radius:10px;}
.close{color:#aaa;float:left;font-size:24px;font-weight:bold;cursor:pointer;}
.close:hover{color:red;}
.modal h3{color:#007bff;text-align:center;}
.modal table{width:100%;border-collapse:collapse;margin-top:10px;}
.modal th,.modal td{border:1px solid #ddd;padding:8px;text-align:center;}
.modal th{background:#007bff;color:#fff;}
/* 🔍 بحث ذكي */
.search-box{position:relative;background:#fff;border:1px solid #ddd;border-radius:6px;max-height:180px;overflow-y:auto;display:none;margin-bottom:10px;z-index:999;}
.search-item{padding:8px 10px;cursor:pointer;border-bottom:1px solid #eee;}
.search-item:hover{background:#f1f1f1;}
.no-result{color:#888;text-align:center;}
</style>
</head>
<body>
<div class="container">
<h2>📋 سجل السلوك الإداري للطلبة</h2>

<?php 
if(isset($success)) echo "<div class='success'>$success</div>"; 
if(isset($deleted)) echo "<div class='deleted'>$deleted</div>";
?>
<div class="note">⚠️ هذا النموذج مخصص لتسجيل <b>المشكلات السلوكية</b> للطلبة من قبل الإدارة فقط.</div>

<form method="post">
    <label>👨‍🎓 اسم الطالب:</label>
    <input type="text" id="studentSearch" placeholder="ابحث باسم الطالب..." autocomplete="off" required>
    <input type="hidden" name="student_id" id="student_id">
    <div id="searchResults" class="search-box"></div>

    <label>⚠️ نوع المشكلة:</label>
    <input type="text" name="problem_type" placeholder="مثال: سلوك عدواني، غياب متكرر..." required>

    <label>📝 تفاصيل المشكلة / الملاحظة:</label>
    <textarea name="problem_note" rows="3" placeholder="اكتب تفاصيل المشكلة أو الملاحظة..." required></textarea>

    <label>📅 تاريخ المشكلة:</label>
    <input type="date" name="problem_date" required>

    <div style="text-align:center;">
        <button type="submit">💾 حفظ السجل</button>
    </div>
</form>

<div class="records">
<h2 style="background:#28a745;">📜 السجلات السابقة</h2>
<div class="table-container">
<table>
<tr>
<th>#</th>
<th>اسم الطالب</th>
<th>المرحلة</th>
<th>الشعبة</th>
<th>عدد المشاكل</th>
<th>آخر تاريخ مشكلة</th>
<th>التحكم</th>
</tr>

<?php
if ($records && mysqli_num_rows($records) > 0) {
    $i = 1;
    while($r = mysqli_fetch_assoc($records)) {
        $badge = ($r['total_problems'] >= 5) ? 'badge-danger' : (($r['total_problems'] >= 3) ? 'badge-warning' : 'badge-success');
        echo "<tr>
        <td>$i</td>
        <td>".htmlspecialchars($r['name'])."</td>
        <td>".htmlspecialchars($r['stage'])."</td>
        <td>".htmlspecialchars($r['class'])."</td>
        <td><span class='badge $badge'>".$r['total_problems']."</span></td>
        <td>".htmlspecialchars($r['last_date'])."</td>
        <td>
            <a href='#' class='details-btn' onclick='showDetails(".$r['student_id'].")'>🧾 التفاصيل</a>
            <a href='?delete=".$r['student_id']."' class='delete-btn' onclick='return confirm(\"⚠️ هل أنت متأكد من حذف جميع مشاكل هذا الطالب؟\")'>🗑️ حذف</a>
        </td>
        </tr>";
        $i++;
    }
} else {
    echo "<tr><td colspan='7' style='color:red;font-weight:bold;'>❌ لا توجد سجلات حالياً.</td></tr>";
}
?>
</table>
</div>
</div>

<!-- نافذة التفاصيل -->
<div id="detailsModal" class="modal">
  <div class="modal-content">
    <span class="close" onclick="document.getElementById('detailsModal').style.display='none'">&times;</span>
    <h3>🧾 تفاصيل السلوك للطالب</h3>
    <div id="detailsContent">جاري التحميل...</div>
  </div>
</div>

<p style="text-align:center;">
    <a class="back" href="admin_dashboard.php">⬅ العودة إلى لوحة التحكم</a>
</p>
</div>

<script>
// 🔍 بحث ذكي باسم الطالب
const input = document.getElementById('studentSearch');
const resultsBox = document.getElementById('searchResults');
const hiddenId = document.getElementById('student_id');

input.addEventListener('keyup', function(){
    const query = this.value.trim();
    if(query.length < 1){
        resultsBox.style.display = 'none';
        return;
    }

    fetch('search_students.php?q=' + encodeURIComponent(query))
    .then(res => res.text())
    .then(html => {
        resultsBox.innerHTML = html;
        resultsBox.style.display = 'block';
        document.querySelectorAll('.search-item').forEach(item=>{
            item.addEventListener('click', ()=>{
                if(item.classList.contains('no-result')) return;
                input.value = item.textContent.trim();
                hiddenId.value = item.getAttribute('data-id');
                resultsBox.style.display = 'none';
            });
        });
    });
});

// إخفاء القائمة عند النقر خارجها
document.addEventListener('click', (e)=>{
  if(!resultsBox.contains(e.target) && e.target !== input){
    resultsBox.style.display = 'none';
  }
});

// نافذة التفاصيل
function showDetails(studentId){
    const modal = document.getElementById('detailsModal');
    const content = document.getElementById('detailsContent');
    modal.style.display = 'block';
    content.innerHTML = '⏳ جاري تحميل التفاصيل...';
    fetch('fetch_behavior_details.php?student_id=' + studentId)
    .then(res => res.text())
    .then(html => { content.innerHTML = html; })
    .catch(() => { content.innerHTML = '❌ حدث خطأ أثناء تحميل التفاصيل.'; });
}
window.onclick = function(event) {
  const modal = document.getElementById('detailsModal');
  if (event.target == modal) modal.style.display = "none";
}
</script>
</body>
</html>
